<?php

namespace Drupal\webform_authorize_net_payment\Service;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Utility class for providing services.
 */
class ServiceUtil implements ContainerInjectionInterface {
  /**
   * The dependency injection container.
   *
   * @var \Symfony\Component\DependencyInjection\ContainerInterface
   */
  protected $container;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static($container);
  }

  /**
   * Constructs a ServiceUtil object.
   *
   * @param \Drupal\Core\DependencyInjection\ContainerInterface $container
   *   The container.
   */
  public function __construct(ContainerInterface $container) {
    $this->container = $container;
  }

  /**
   * Gets the expire recurring payment service.
   *
   * @return \Drupal\webform_authorize_net_payment\Controller\AuthorizeNetWebformExpireRecurringPaymentController
   *   The expire recurring payment service.
   */
  public static function getExpireRecurringPaymentService() {
    return \Drupal::service('webform_authorize_net_payment.expire_recurring');
  }

  /**
   * Gets the cancel recurring payment service.
   *
   * @return \Drupal\webform_authorize_net_payment\Controller\AuthorizeNetWebformCancelRecurringPaymentController
   *   The expire recurring payment service.
   */
  public static function getCancelRecurringPaymentService() {
    return \Drupal::service('webform_authorize_net_payment.cancel_recurring');
  }

  /**
   * Gets the cancel recurring payment service.
   *
   * @return \Drupal\webform_authorize_net_payment\Controller\AuthorizeNetWebformRecurringPaymentGetSubscriptionController
   *   The expire recurring payment service.
   */
  public static function getRecurringPaymentService() {
    return \Drupal::service('webform_authorize_net_payment.get_recurring');
  }

  public static function getUpdateRecurringPaymentService() {
    return \Drupal::service('webform_authorize_net_payment.update_payment_recurring');
  }

}
