<?php // $Id: pay_method_gateway_authorizenet.inc,v 1.1 2010/11/01 20:16:52 vauxia Exp $

/**
 * @file
 */

class pay_method_gateway_authorizenet extends pay_method_gateway {
  var $authorizenet_login = '';
  var $authorizenet_key = '';
  var $authorizenet_email_customer = 0;
  var $authorizenet_email_merchant = 1;
  var $authorizenet_developer = 0;

  var $gateway_supports_ach = TRUE;
  var $gateway_supports_cc = TRUE;
  var $gateway_supports_recurring = TRUE;

  function gateway_url() {
    $url = 'https://secure.authorize.net/gateway/transact.dll';
    if ($this->authorizenet_developer) {
      $url = 'https://test.authorize.net/gateway/transact.dll';
    }
    return $url;
  }

  function gateway_request() {
    // Set the transaction type based on requested activity.
    if (!$txntype = $this->authorizenet_trxtype($this->activity->activity)) {
      drupal_set_message("Payment activity '$this->activity->activity' is unsupported. Not processing transaction", 'error');
      return FALSE;
    }

    $req = '';
    foreach ($this->gateway_request_values($txntype) as $key => $val) {
      if ($val = trim($val)) $req .= check_plain($key) .'='. urlencode($val) .'&'; 
    }
    return $req;
  }
  
  // TODO
  function gateway_response($result) {
    $r = explode(',', ($result));

    // Save the transaction ID for tracking and/or future operations.
    $this->activity->identifier = $r[6];

    $response_code = $r[0];
  
    $this->activity->data = array(
      'response_string' => $r[3],
      'approval_code'   => $r[4],
      'avs_response'    => $r[5],
      'caav_response'   => $r[39],
    );

    /* Return TRUE if response_code = 1. Possible values:
      1 = Approved
      2 = Declined
      3 = Error
      4 = Held for Review
    */

    if ($response_code != 1) {
      watchdog('payment', "Error processing payment: Authorize.Net gateway returned '@err'", array('@err' => $this->activity->data['response_string']));
      drupal_set_message("Error processing payment: Authorize.Net gateway returned'". $this->activity->data['response_string']. "'");
    }

    return ($response_code == 1);
  }

  function settings_form(&$form, &$form_state) {
    parent::settings_form($form, $form_state);
    $group = $this->handler();

    $form[$group]['an']['#type'] = 'fieldset';
    $form[$group]['an']['#collapsible'] = FALSE;
    $form[$group]['an']['#title'] = t('Authorize.Net settings');
    $form[$group]['an']['#group'] = $group;

    $form[$group]['an']['authorizenet_login'] = array(
      '#type' => 'textfield',
      '#title' => t('Authorize.Net login'),
      '#default_value' => $this->authorizenet_login,
      '#required' => TRUE,
      '#parents' => array($group, 'authorizenet_login'),
    );
    $form[$group]['an']['authorizenet_key'] = array(
      '#type' => 'textfield',
      '#title' => t('Authorize.Net transaction key'),
      '#default_value' => $this->authorizenet_key,
      '#required' => TRUE,
      '#parents' => array($group, 'authorizenet_key'),
    );
    $form[$group]['an']['authorizenet_developer'] = array(
      '#type' => 'checkbox',
      '#title' => t('This is a developer test account'),
      '#description' => t('You can obtain a developer test account from http://developer.authorize.net/ and use those credentials for development and testing. If the above values belong to a developer test account and not a real merchant account, check this box.'),
      '#default_value' => $this->authorizenet_developer,
      '#parents' => array($group, 'authorizenet_developer'),
    );
    $form[$group]['an']['authorizenet_email_customer'] = array(
      '#type' => 'checkbox',
      '#title' => t('E-mail a reciept to the customer'),
      '#default_value' => $this->authorizenet_email_customer,
      '#parents' => array($group, 'authorizenet_email_customer'),
    );
    $form[$group]['an']['authorizenet_email_merchant'] = array(
      '#type' => 'checkbox',
      '#title' => t('E-mail a reciept to the merchant'),
      '#default_value' => $this->authorizenet_email_merchant,
      '#parents' => array($group, 'authorizenet_email_merchant'),
    );
  }

  function authorizenet_trxtype($activity) {
    // S:Sale C:Credit A:Auth D:Delayed V:Void F:Voice I:Inquiry N:Duplicate    
    $trxtypes = array(
      'complete'  => 'AUTH_CAPTURE',
      'authorize' => 'AUTH_ONLY',
      'capture'   => 'CAPTURE_ONLY',
      'void'      => 'VOID',
      'credit'    => 'CREDIT',
    );
    return $trxtypes[$activity];
  }

  // TODO
  function gateway_request_values($txntype) {
    $data = array(
      'x_version'         => '3.1',
      'x_delim_data'      => 'TRUE',
      'x_relay_response'  => 'FALSE',
      'x_login'           => $this->authorizenet_login,
      'x_tran_key'        => $this->authorizenet_key,
      'x_amount'          => $this->total(),
      'x_type'            => $txntype,
      'x_method'          => 'CC', // TODO (or ECHECK)
      'x_card_num'        => $this->cc_number,
      'x_exp_date'        => $this->cc_expiration(),
      'x_card_code'       => $this->cc_ccv2,
      'x_trans_id'        => $this->identifier,
      'x_auth_code'       => '', // TODO required for CAPTURE_ONLY
      'x_invoice_num'     => $this->activity->pxid,
      'x_description'     => $this->note,
      'x_first_name'      => $this->first_name,
      'x_last_name'       => $this->last_name,
      'x_address'         => $this->billto['street1'],
      'x_city'            => $this->billto['city'],
      'x_state'           => $this->billto['state'],
      'x_zip'             => $this->billto['zip'],
      'x_country'         => $this->billto['country'],
      'x_phone'           => $this->billto['phone'],
      'x_fax'             => '',
      'x_email'           => $this->mail,
      'x_cust_id'         => '',
      'x_cust_ip'         => ip_address(),
      'x_email_customer'  => $this->authorizenet_email_customer,
      'x_email_merchant'  => $this->authorizenet_email_merchant,

      'x_recurring_billing' => '', // T, F
    );

    if ($this->gateway_testmode) {
      $data['x_test_request']  = 'TRUE';
    }

    return $data;
  }
}
