# AUTO_INCREMENT Alter

This module allows altering the AUTO_INCREMENT value of database tables.

One use case is to prevent entity ID conflicts when performing Drupal upgrades.

See https://www.drupal.org/docs/upgrading-drupal/upgrading-from-drupal-6-or-drupal-7/known-issues-when-upgrading-from-drupal-6-or-7#id_conflicts

See https://www.udrupal.com/auto-increment-alter-documentation

## REQUIREMENTS

At the moment the module only works with the MySQL driver. The core
`drupal:mysql` module must be enabled.

## INSTALLATION

This module is installed like any other contributed module. For further
information, see [Installing Drupal
Modules](https://drupal.org/docs/extending-drupal/installing-drupal-modules).

## CONFIGURATION / USAGE

The module provides a `auto_increment_alter.mysql` service which offers the
following functionality:

- Alter the AUTO_INCREMENT value of a single table.

```
drush php:eval "\Drupal::service('auto_increment_alter.mysql')->alterTable('node', 500);"
```

- Alter the AUTO_INCREMENT value of multiple tables based on the
`auto_increment_alter_tables` setting.

```
drush php:eval "\Drupal::service('auto_increment_alter.mysql')->alterTables();"
```

This expects an `auto_increment_alter_tables` setting containing an associative
array of table and value pairs. The keys should be the name of the table to
alter. The array values should be integers containing the new AUTO_INCREMENT
value. For example:

```php
$settings['auto_increment_alter_tables'] = [
  'node' => 500,
  'node_revision' => 1000,
  'users' => 100,
  'taxonomy_term_data' => 200,
  'taxonomy_term_revision' => 200,
  'file_managed' => 300,
  'media' => 700,
  'media_revision' => 700,
];
```

- Alter the AUTO_INCREMENT value of a single table based on the
`auto_increment_alter_content_entities` setting.

```
drush php:eval "\Drupal::service('auto_increment_alter.mysql')->alterContentEntities();"
```

This expects an `auto_increment_alter_content_entities` setting containing an
associative array of table and value pairs. If a content entity is set, but it
does not exist in the current installation it will be filtered out before
calling the alter operation. The base and revision tables for the content
entity are identified using the `entity_type.manager` service.

The setting's keys should be the machine name of the content entities. The array
values can be set in three ways:

1. An array with two integer values. The first is used for the base table and
   the second is used for the revision table.
2. An array with one integer value. It is used for both the base and revisions
   tables.
3. An integer value. It is used for both the base and revisions tables.

Some content entities do not make use of revision tables. In those cases, the
revision value is ignored even if set.

```php
$settings['auto_increment_alter_content_entities'] = [
  'node' => [500, 1000],
  'user' => [100],
  'taxonomy_term' => [200],
  'file' => 300,
  'media' => 700,
];
```

- Get a list of entities, optionally filtered by group.

```
drush php:eval "print_r(array_keys(\Drupal::service('auto_increment_alter.mysql')->getEntityList()));"
drush php:eval "print_r(array_keys(\Drupal::service('auto_increment_alter.mysql')->getEntityList('content')));"
drush php:eval "print_r(array_keys(\Drupal::service('auto_increment_alter.mysql')->getEntityList('configuration')));"
```

The code snippets above use [Drush](https://www.drush.org) as an example to call
the `auto_increment_alter.mysql` service. Drush is not a requirement to use this
module.

See `example.settings.auto_increment_alter.php` for an example on how to
configure the variables used by this module.

## MAINTAINERS

Current maintainers:

- Mauricio Dinarte (dinarcon) - https://www.drupal.org/u/dinarcon

Ongoing development is sponsored by:

- [Agaric](https://agaric.coop/)
- [UnderstandDrupal.com](https://understanddrupal.com/)

The best way to contact the authors is to submit an issue, be it a support
request, a feature request or a bug report, in the [project issue
queue](https://www.drupal.org/project/issues/auto_increment_alter).
