<?php

declare(strict_types=1);

namespace Drupal\auto_increment_alter;

/**
 * Alter AUTO_INCREMENT service for MySQL.
 */
final class AutoIncrementAlterMysql extends AutoIncrementAlter {

  /**
   * {@inheritdoc}
   */
  public string $supportedDatabaseType = 'mysql';

  /**
   * {@inheritdoc}
   */
  protected function alterTableAutoIncrement($table, $value, $ensure_table = TRUE): void {
    if ($ensure_table === TRUE) {
      $exists = $this->database->schema()->tableExists($table);

      if (!$exists) {
        $this->logger->error("Cannot alter nonexistent $table table.");
        return;
      }
    }

    if ($value < 0) {
      $this->logger->error("Cannot set AUTO_INCREMENT for $table table to a negative value.");
      return;
    }

    $query = "ALTER TABLE {" . $table . "} AUTO_INCREMENT = " . $value;
    $result = $this->database->query($query)->execute();

    if ($result === TRUE) {
      $this->logger->info("AUTO_INCREMENT value for table $table set to $value.");
    }
    else {
      $this->logger->error("It was not possible to set the AUTO_INCREMENT value for $table table.");
    }
  }

}
