# AUTO_INCREMENT Alter

This module allows altering the AUTO_INCREMENT value of database tables.

One use case is to prevent entity ID conflicts when performing Drupal upgrades.

See https://www.drupal.org/docs/upgrading-drupal/upgrading-from-drupal-6-or-drupal-7/known-issues-when-upgrading-from-drupal-6-or-7#id_conflicts

See https://www.udrupal.com/auto-increment-alter-documentation

## REQUIREMENTS

At the moment the module only works with the MySQL driver. The core
`drupal:mysql` module must be enabled.

## INSTALLATION

This module is installed like any other contributed module. For further
information, see [Installing Drupal
Modules](https://drupal.org/docs/extending-drupal/installing-drupal-modules).

## CONFIGURATION / USAGE

The module provides the `auto_increment_alter.mysql` [service](https://www.drupal.org/docs/drupal-apis/services-and-dependency-injection)
and various [Drush](https://www.drush.org) commands offering the following functionality:

- Alter the AUTO_INCREMENT value for a single table.

```
drush auto-increment-alter:table node 500
```

- Alter the AUTO_INCREMENT value for multiple tables based on the
`auto_increment_alter_tables` setting.

```
drush auto-increment-alter:tables
```

This expects an `auto_increment_alter_tables` setting containing an associative
array of table and value pairs. The keys should be the name of the tables to
alter. The array values should be integers indicating the new AUTO_INCREMENT
value. For example:

```php
$settings['auto_increment_alter_tables'] = [
  'node' => 500,
  'node_revision' => 1000,
  'users' => 100,
  'taxonomy_term_data' => 200,
  'taxonomy_term_revision' => 200,
  'file_managed' => 300,
  'media' => 700,
  'media_revision' => 700,
];
```

- Alter the AUTO_INCREMENT value for a single content entity.

```
drush auto-increment-alter:content-entity node 500 1000
drush auto-increment-alter:content-entity user 100
drush auto-increment-alter:content-entity taxonomy_term 200
```

The first argument is the machine name of the content entity. The second
argument is the AUTO_INCREMENT value for the base table. The third argument,
which is optional, is the AUTO_INCREMENT value for the revision table.

If the content entity uses a revision table, but the argument is not set, the
same base table value will be used. Some content entities do not make use of
revision tables. In those cases, the revision value is ignored even if set.

- Alter the AUTO_INCREMENT value for content entity tables based on the
`auto_increment_alter_content_entities` setting.

```
drush auto-increment-alter:content-entities
```

This expects an `auto_increment_alter_content_entities` setting containing an
associative array of table and value pairs. If a content entity is set, but it
does not exist in the current installation it will be filtered out before
calling the alter operation. The base and revision tables for the content
entity are identified using the `entity_type.manager` service.

The setting's keys should be the machine name of the content entities. The array
values can be set in three ways:

1. An array with two integer values. The first is used for the base table and
   the second is used for the revision table.
2. An array with one integer value. It is used for both the base and revisions
   tables.
3. An integer value. It is used for both the base and revisions tables.

Some content entities do not make use of revision tables. In those cases, the
revision value is ignored even if set.

```php
$settings['auto_increment_alter_content_entities'] = [
  'node' => [500, 1000],
  'user' => [100],
  'taxonomy_term' => [200],
  'file' => 300,
  'media' => 700,
];
```

- Get the list of entities, optionally filtered by group.

```
drush auto-increment-alter:entity-list
drush auto-increment-alter:entity-list --group=content
drush auto-increment-alter:entity-list --group=configuration
```

- Get the list of tables.

```
drush auto-increment-alter:table-list
```

- Get the AUTO_INCREMENT value for a single table.

```
drush auto-increment-alter:value node
```

- Get the AUTO_INCREMENT value for multiple tables.

```
drush auto-increment-alter:values
drush auto-increment-alter:values --all
```

This returns table names and their corresponding AUTO_INCREMENT value.

Example:

```
 ---------------------------- ----------------------
  Table name                   AUTO_INCREMENT value
 ---------------------------- ----------------------
  block_content                2
  block_content_revision       3
  comment                      5
  file_managed                 8
```

If the `--all` option is provided, the output will include tables that do not
have the AUTO_INCREMENT value set.

See `example.settings.auto_increment_alter.php` for an example on how to
configure the variables used by this module.

## MAINTAINERS

Current maintainers:

- Mauricio Dinarte (dinarcon) - https://www.drupal.org/u/dinarcon

Ongoing development is sponsored by:

- [Agaric](https://agaric.coop/)
- [UnderstandDrupal.com](https://understanddrupal.com/)

The best way to contact the authors is to submit an issue, be it a support
request, a feature request or a bug report, in the [project issue
queue](https://www.drupal.org/project/issues/auto_increment_alter).
