<?php

/**
 * @file
 * Provides an example for configuring the settings used by the module.
 *
 * Copy the examples to settings.php and adjust as needed.
 */

/**
 * Alter the AUTO_INCREMENT value for multiple tables.
 *
 * @see \Drupal\auto_increment_alter\AutoIncrementAlterInterface::alterTables()
 */
$settings['auto_increment_alter_tables'] = [
  'node' => 500,
  'node_revision' => 1000,
  'users' => 100,
  'taxonomy_term_data' => 200,
  'taxonomy_term_revision' => 200,
  'file_managed' => 300,
  'media' => 700,
  'media_revision' => 700,
];

/**
 * Alter the AUTO_INCREMENT value for multiple content entities.
 *
 * @see \Drupal\auto_increment_alter\AutoIncrementAlterInterface::alterContentEntities
 */
$settings['auto_increment_alter_content_entities'] = [
  'node' => [500, 1000],
  'user' => [100],
  'taxonomy_term' => [200],
  'file' => 300,
  'media' => 700,
];
