<?php

namespace Drupal\auto_node_translate\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class ConfigForm.
 */
class ConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'auto_node_translate.config',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'auto_node_translate_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('auto_node_translate.config');
    $form['watson_api'] = [
      '#type' => 'details',
      '#title' => $this->t('IBM Watson API Configuration'),
    ];
    $form['watson_api']['ibm_watson_apikey'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Api key'),
      '#description' => $this->t('the IBM watson api key'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('ibm_watson_apikey'),
    ];
    $form['watson_api']['ibm_watson_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Url'),
      '#description' => $this->t('the ibm watson url'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('ibm_watson_url'),
    ];
    $form['watson_api']['ibm_watson_version'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Version'),
      '#description' => $this->t('The Api Version in the format YYYY-MM-DD defaults to 2018-05-01'),
      '#maxlength' => 10,
      '#size' => 10,
      '#default_value' => empty($config->get('ibm_watson_version')) ? '2018-05-01' : $config->get('ibm_watson_version'),
    ];
    $form['google_api'] = [
      '#type' => 'details',
      '#title' => $this->t('Google API Configuration'),
    ];
    $form['google_api']['google_apikey'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Api key'),
      '#description' => $this->t('The Google api key'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('google_apikey'),
    ];
    $form['google_api']['google_api_project'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Project ID'),
      '#description' => $this->t('Your Google Cloud Platform project ID'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('google_api_project'),
    ];
    $form['default_api'] = [
      '#type' => 'select',
      '#title' => $this->t('Default API'),
      // The values are the class name that implents the TranslationApiInterface
      // for the API.
      '#options' => [
        'IbmWatsonTranslationApi' => 'IBM Watson',
        'MyMemoryTranslationApi' => 'My Memory',
        'GoogleTranslationApi' => 'Google Cloud Translate V2',
      ],
      '#default_value' => $config->get('default_api'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('auto_node_translate.config')
      ->set('ibm_watson_apikey', $form_state->getValue('ibm_watson_apikey'))
      ->set('ibm_watson_url', $form_state->getValue('ibm_watson_url'))
      ->set('ibm_watson_version', $form_state->getValue('ibm_watson_version'))
      ->set('google_api_project', $form_state->getValue('google_api_project'))
      ->set('google_apikey', $form_state->getValue('google_apikey'))
      ->set('default_api', $form_state->getValue('default_api'))
      ->save();
  }

}
