<?php

namespace Drupal\auto_node_translate;

/**
 * TranslationApiInterface.
 */
interface TranslationApiInterface {

  /**
   * Translates Text.
   *
   * @param string $text
   *   - The text to translate.
   * @param string $from
   *   - Langcode of original language.
   * @param string $to
   *   - Langcode of destination language.
   *
   * @return string
   *   - the translated string
   */
  public function translate($text, $from, $to);

}
