<?php

namespace Drupal\auto_node_translate;

use Google\Cloud\Translate\TranslateClient;
use Drupal\Core\Url;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Description of GoogleTranslationAPI.
 *
 * Implementation of TranslationApiInterface for Google Cloud Translation V2.
 */
class GoogleTranslationApi implements TranslationApiInterface {

  use StringTranslationTrait;
  /**
   * {@inheritdoc}
   */
  public function translate($text, $languageFrom, $languageTo) {

    $from = explode('-', $languageFrom)[0];
    $to = explode('-', $languageTo)[0];

    $config = \Drupal::config('auto_node_translate.config');
    $projectId = trim($config->get('google_api_project'));
    $apiKey = trim($config->get('google_apikey'));

    if (empty($projectId) || empty($apiKey)){
      
    }
    $translate = new TranslateClient([
      'projectId' => $projectId,
    ]);

    $translation = $translate->translate($text, [
      'source' => $from,
      'target' => $to,
      'key' => $apiKey,
    ]);

    if (!empty($translation['text'])) {
      $translatedText = $translation['text'];
    }
    else {
      $translatedText = $text;
      $link = Url::fromRoute('auto_node_translate.config_form', [], ['absolute' => TRUE])->toString();

      \Drupal::messenger()->addStatus($this->t('Error for Google Translation. Try changing the default Api in <a href=@link>@link</a>'), ['@link' => $link]);
    }
    return $translatedText;
  }

}
