<?php

declare(strict_types=1);

namespace Drupal\auto_node_translate_amazon\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Auto Node Translate Libre settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'auto_node_translate_amazon_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['auto_node_translate_amazon.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('auto_node_translate_amazon.settings');
    $form['amazon_translate_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Api Key'),
      '#description' => $this->t('the Amazon Translate api key'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('amazon_translate_key'),
      '#required' => TRUE,
    ];

    $form['amazon_translate_secret'] = [
      '#type' => 'password',
      '#title' => $this->t('Secret'),
      '#description' => $this->t('the Amazon Translate secret'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('amazon_translate_secret'),
      '#required' => TRUE,
    ];

    $form['amazon_translate_region'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Region'),
      '#description' => $this->t('the Amazon Translate region'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('amazon_translate_region'),
      '#required' => TRUE,
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('auto_node_translate_amazon.settings')
      ->set('amazon_translate_key', $form_state->getValue('amazon_translate_key'))
      ->set('amazon_translate_secret', $form_state->getValue('amazon_translate_secret'))
      ->set('amazon_translate_region', $form_state->getValue('amazon_translate_region'))
      ->save();
  }

}
