<?php

declare(strict_types=1);

namespace Drupal\auto_node_translate_libre\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Auto Node Translate Libre settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'auto_node_translate_libre_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['auto_node_translate_libre.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('auto_node_translate_libre.settings');
    $form['libretranslate_apikey'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Api Key'),
      '#description' => $this->t('The LibreTranslate api key'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('libretranslate_apikey'),
      '#required' => TRUE,
    ];

    $form['libretranslate_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Url'),
      '#description' => $this->t('The LibreTranslate base url, ex: "https://libretranslate.com/"'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('libretranslate_url'),
      '#required' => TRUE,
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('auto_node_translate_libre.settings')
      ->set('libretranslate_url', $form_state->getValue('libretranslate_url'))
      ->set('libretranslate_apikey', $form_state->getValue('libretranslate_apikey'))
      ->save();
  }

}
