<?php

namespace Drupal\auto_retina\Entity;

use Drupal\image\Entity\ImageStyle;

/**
 * Image style class to support retina generation.
 */
class RetinaImageStyle extends ImageStyle {

  /**
   * {@inheritdoc}
   */
  public function createDerivative($original_uri, $derivative_uri) {
    // If this is a retina derivative it will contain our quality multiplier.
    $quality_multiplier = $this->getThirdPartySetting('auto_retina', 'quality_multiplier');
    if ($quality_multiplier !== NULL && $quality_multiplier != 1) {
      // We must alter quality.  First see if image_style_quality is doing
      // something for this image.  If that module controls the quality then we
      // tweak it's settings.  Otherwise alter quality at the system level.
      if ($this->getEffects()->has('image_style_quality')) {
        $effect = $this->getEffect('image_style_quality');
        $config = $effect->getConfiguration();
        $config['data']['quality'] = (int) ($quality_multiplier * $config['data']['quality']);
        $effect->setConfiguration($config);
      }
      else {
        $config_factory = \Drupal::service('config.factory');
        if ($this->getImageFactory()->getToolkitId() === 'imagemagick') {
          $config = $config_factory->get('imagemagick.settings');
          $config->setModuleOverride([
            'quality' => $quality_multiplier * $config->get('quality'),
          ]);
        }
        else {
          $config = $config_factory->get('system.image.gd');
          $config->setModuleOverride([
            'jpeg_quality' => (int) ($quality_multiplier * $config->get('jpeg_quality')),
          ]);
        }
      }
    }

    // Let modules alter.
    \Drupal::service('module_handler')
      ->alter('auto_retina_create_derivative', $this, $original_uri, $derivative_uri);

    // Let core handle the rest.
    return parent::createDerivative($original_uri, $derivative_uri);
  }

}
