/**
 * DO NOT EDIT THIS FILE.
 * @translate
 **/

(function ($, Drupal) {
    /**
     * Allows submit buttons in entity forms to trigger uploads by undoing
     * work done by Drupal.behaviors.fileButtons.
     */
    Drupal.behaviors.translate = {
        translateFields: function (context, drupalSettings) {
            var path = window.location.pathname;
            var newPath = path;
            var t_lang = newPath.substring(newPath.lastIndexOf("/") + 1);
            var str = newPath;
            var defString = str.replace(t_lang, '');
            var newString = defString.replace('/' + t_lang, '');
            var d_lang = newString.substring(newString.lastIndexOf('/') + 1);
            var form = $('.node-form');

            form.find('input.form-text').each(function () {
                try {
                    if ($(this).val()) {
                        var val;

                        if ($(this).attr('type').includes('text') &&
                                !$(this).attr('id').includes('edit-uid') &&
                                !$(this).attr('id').includes('edit-content-translation-uid')) {
                            val = $(this).val() ? $(this).val().toString() : '';
                            var obj = {'parameter': {
                                    'field': $(this).attr('id'),
                                    'source': d_lang,
                                    'target': t_lang,
                                    'q': val.toString()
                                }};

                            var fieldId = $(this).attr('id');
                            var url = "https://translate.googleapis.com/translate_a/single?client=gtx&sl="
                                    + d_lang + "&tl=" + t_lang + "&dt=t&q=" + encodeURI(val.toString());
                            $.getJSON(url, function (data) {
                                console.log('tranlsation', data[0][0][0]);
                                if (data[0][0][0]) {
                                    $('#' + fieldId).val(data[0][0][0]);
                                }
                            });
                        }
                    }
                }
                catch (error) {
                    // expected output: ReferenceError: nonExistentFunction is not defined
                    // Note - error messages will vary depending on browser
                    console.error(error);
                }

            });
        }
    };
    Drupal.behaviors.translate.translateFields();
})(jQuery, Drupal);



