# Auto Translation Module for Drupal 10

## Description

The Auto Translation module provides automed translation capability
for Drupal 10 websites. It integrates with Google translation services
free or paid to automatically translate content on your site.

## Features

- Automatic translation of content using translation services free or paid
- Configurable translation settings
- Integration with Drupal's multilingual features
- Google Translation integration true Server or Client
- LiberTranslate integration true Server API call
- Drupal AI Translate integration with favourited provider

## Requirements

- Drupal 10.x or higher
- Translation and languages configured

## Installation

1. Download and enable the Auto Translation module.
2. Configure the Auto Translation module to specify the translation service
  provider and other options.

## Usage

1. Enable one or more languages in addition to the default one
2. Click on Translate button of the content that you want auto translate
3. Add the translation check the form with auto translated fields to verify the
  automated translation
4. Save the node and publish the translation

## Configuration

1. Go to Extend > Modules in the Drupal administration panel.
2. Click the Configure link next to the Auto Translator module.

Enter the following settings:

1. Content Types: The Content Types where you want enable auto translation
2. API type: The type of Google Translate API you want to use.
3. API key: Your Google Translate API key.
4. API secret key: Your Google Translate API secret key.
5. Drupal AI: install Drupal AI and Drupal AI Translate module and configure desidered provider.

To configure the Auto Translation module, browse the "Configuration->Region and
language" page in your Drupal admin interface. Here, you can access the Auto
Translation settings and configure the translation service provider, language
settings, and other options.

## Contributing

Contributions to the Auto Translation module are welcome!
If you encounter any issues or have suggestions for improvements,
please submit an issue or pull request on the
module's GitHub repository of Drupal.

## Maintainers

- Alberto Cocchiara (bigbabert)

## License

This project is licensed under the GPL-2.0-or-later.
