<?php

namespace Drupal\auto_translation\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Auto translate and save as draft action.
 *
 * @Action(
 *   id = "auto_translation_bulk_auto_translate_draft_action",
 *   label = @Translation("Auto Translate and Save as Draft"),
 *   type = "node"
 * )
 */
class BulkAutoTranslateDraft extends ActionBase {

    /**
     * {@inheritdoc}
     */
    public function execute($entity = NULL) {
        if ($entity instanceof ContentEntityInterface) {
            // Get the original language of the entity.
            $d_lang = $entity->language()->getId();
            $languages = \Drupal::service('language_manager')->getLanguages();
            $form = [];
            $action_value = "draft";
            $action = $action_value;

            foreach ($languages as $lang) {
                if ($entity->hasTranslation($lang->getId())) {
                    continue;
                }

                if ($lang->getId() !== $d_lang) {
                    $t_lang = $lang->getId();
                    // Translate entity.
                    \Drupal::service('auto_translation.utility')
                        ->formTranslate($form, $form, $entity, $t_lang, $d_lang, $action);
                }
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
        return $object instanceof ContentEntityInterface && $object->access('update', $account, $return_as_object);
    }
}
