<?php

/**
 * @file
 * Filter file for autoarch
 */

/**
 * Implements hook_views_handlers().
 */
function autoarch_views_handlers() {
  return array(
    'info' => array(
      'path' => drupal_get_path('module', 'autoarch') . '/views',
    ),
    'handlers' => array(
      'AutoarchFilterMultiple' => array(
        'parent' => 'views_handler_filter',
      ),
    ),
  );
}

/**
 * Implements hook_views_data().
 */
function autoarch_views_data() {
  $data = array();
  $data['autoarch_state']['state'] = array(
    'group' => t('Autoarch'),
    'real field'  => 'state',
    'title' => t('State of the node'),
    'help' => t('Actual') . ' / ' . t('Archive'),
    'filter' => array(
      'handler' => 'AutoarchFilterMultiple',
    ),
  );
  $data['autoarch_state']['table']['group'] = t('Autoarch');
  $data['autoarch_state']['table']['join']['node'] = array(
    'left_field' => 'nid',
    'field' => 'nid',
  );
  return $data;
}
