<?php

namespace Drupal\autoban;

/**
 * @file
 * Contains \Drupal\autoban\Utils.
 */

/**
 * Class AutobanUtils.
 *
 * Provides utils.
 *
 * @ingroup autoban
 */
class AutobanUtils {

  const AUTOBAN_FROM_ANALYZE = '*from_analyze*';

  /**
   * Is from Analyze page.
   *
   * @param string $string
   *   Autoban string.
   *
   * @return bool
   *   Is from analyze?
   */
  public static function isFromAnalyze($string) {
    return trim($string) === self::AUTOBAN_FROM_ANALYZE;
  }

}
