<?php

namespace Drupal\autocomplete_id\Element;

use Drupal\Core\Entity\Element\EntityAutocomplete;
use Drupal\Core\Form\FormStateInterface;

/**
 * Extended default autocomplete.
 *
 * Included entity selection by id.
 *
 * The #default_value accepted by this element is either an entity object or an
 * array of entity objects.
 *
 * @see \Drupal\Core\Render\Annotation\FormElement
 * @see \Drupal\Core\Entity\Element\EntityAutocomplete
 * @see plugin_api
 *
 * @FormElement("entity_id_autocomplete")
 */
class EntityIdAutocomplete extends EntityAutocomplete {

  /**
   * {@inheritdoc}
   *
   * Just change autocomplete route name.
   */
  public static function processEntityAutocomplete(array &$element, FormStateInterface $form_state, array &$complete_form) {
    $element = parent::processEntityAutocomplete($element, $form_state, $complete_form);
    $element['#autocomplete_route_name'] = 'autocomplete_id.entity_id_autocomplete';
    return $element;
  }

}
