<?php

declare(strict_types = 1);

namespace Drupal\autofill_fields\Hook;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\WidgetInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for widget settings.
 */
class WidgetHooks {

  /**
   * Implements hook_field_widget_third_party_settings_form().
   */
  #[Hook('field_widget_third_party_settings_form')]
  public function widgetSettingsForm(WidgetInterface $plugin, FieldDefinitionInterface $field_definition, string $form_mode, array $form, FormStateInterface $form_state): array {
    // Skip some fields.
    $skip_list = ['authored_by', 'authored_on', 'title', 'path', 'comment'];
    if (in_array($field_definition->getName(), $skip_list)) {
      return [];
    }
    return [
      'autofill' => [
        '#type' => 'checkbox',
        '#title' => t('Autofill field'),
        '#description' => t('Autofill field for new entities with last used value.'),
        '#default_value' => $plugin->getThirdPartySetting('autofill_fields', 'autofill', FALSE),
      ],
    ];
  }

  /**
   * Implements hook_field_widget_settings_summary_alter().
   */
  #[Hook('field_widget_settings_summary_alter')]
  public function widgetSettingsSummary(array &$summary, array $context): void {
    if ($context['widget']->getThirdPartySetting('autofill_fields', 'autofill')) {
      $summary[] = t('Autofill enabled.');
    }
  }

}
