<?php

/**
 * @file
 * Defines administrative forms for the automatic linking plugin.
 */

/**
 * Defines the automatic linking configuration class.
 */
class AutolinkConfigFormAuto extends AutolinkConfigForm {

  /**
   * Defines the automatic link generation plugin settings form.
   */
  protected function form(&$form_state, $settings) {
    $link_types = $this->fetchArraySetting('link_types');
    // Automatic link generation settings.
    if ($link_types->isEnabled('auto_node') || $link_types->isEnabled('auto_user') || $link_types->isEnabled('auto_term')) {
      $form['automatic'] = array(
        '#type' => 'fieldset',
        '#title' => t('Automatic link generation'),
        '#collapsible' => TRUE,
      );
  
      if (module_exists('taxonomy')) {
        $type_options = array('node' => 'Node', 'user' => 'User', 'taxonomy' => 'Taxonomy Term');
      }
      else {
        $type_options = array('node' => 'Node', 'user' => 'User');
      }
  
      $form['automatic']['auto_node_types'] = array(
        '#type' => 'checkboxes',
        '#title' => t('Limit automatic link generation by content type'),
        '#options' => node_get_types('names'),
        '#default_value' => array_keys($this->getSettings('auto_node_types', node_get_types('names'))),
        '#description' => t('Select which content types automatic links may be applied to.'),
      );
  
      if ($link_types->isEnabled('auto_node')) {
        $form['automatic']['auto_node_types_destination'] = array(
          '#type' => 'checkboxes',
          '#title' => t('Limit automatic link destinations by node type'),
          '#options' => node_get_types('names'),
          '#default_value' => array_keys($this->getSettings('auto_node_types_destination', node_get_types('names'))),
          '#description' => t('Select which content types may be linked to.'),
        );
      }
      if ($link_types->isEnabled('auto_user')) {
        $form['automatic']['auto_user_roles'] = array(
          '#type' => 'checkboxes',
          '#title' => t('Limit automatic link destinations by user role'),
          '#options' => user_roles(),
          '#default_value' => array_keys($this->getSettings('auto_user_roles', user_roles())),
          '#description' => t('User roles that are not selected will not be considered '.
                              'for automatic link generation. i.e. If <i>administrator</i> is not '.
                              'selected then Autolink will not seek out user name under the '.
                              'role of <i>administrator</i>'),
        );
      }
      if ($link_types->isEnabled('auto_term')) {
        $vocabularies = array();
        $result = db_query('SELECT * FROM {vocabulary}');
        while ($voc = db_fetch_object($result)) {
          $vocabularies[$voc->vid] = $voc->name;
        }
        $form['automatic']['auto_vocabularies'] = array(
          '#type' => 'select',
          '#title' => t('Limit autolink link detection by vocabulary'),
          '#multiple' => TRUE,
          '#options' => $vocabularies,
          '#default_value' => array_keys($this->getSettings('auto_vocabularies', $vocabularies)),
          '#description' => t('Terms within the selected vocabularies will be sought in '.
                              'node content.'),
        );
      }
    }

    // Add pattern processing with Token for link titles.
    if (module_exists('token') && $link_types->isEnabled('auto_node') || $link_types->isEnabled('auto_user') || $link_types->isEnabled('auto_term')) {
      $form['token_settings'] = array(
        '#type' => 'fieldset',
        '#title' => t('Token replacement patterns'),
        '#collapsible' => TRUE,
      );
  
      if ($link_types->isEnabled('auto_node')) {
        $form['token_settings']['node_title'] = array(
          '#type' => 'textfield',
          '#title' => t('Pattern replacement for node links'),
          '#default_value' => $this->get('node_title', '[title]'),
          '#description' => t('Title patterns are used to generate link text when generating '.
                              'links in blocks or as part of the <i>title</i> attribute in links '.
                              'that are generated in node content.'),
        );
        $form['token_settings']['node_token_help'] = array(
          '#type' => 'fieldset',
          '#title' => t('Replacement patterns'),
          '#collapsible' => TRUE,
          '#collapsed' => TRUE,
        );
        $form['token_settings']['node_token_help']['node_help'] = array(
          '#value' => theme('token_help', 'node'),
        );
      }
  
      if ($link_types->isEnabled('auto_user')) {
        $form['token_settings']['user_title'] = array(
          '#type' => 'textfield',
          '#title' => t('Pattern replacement for user links'),
          '#default_value' => $this->get('user_title', '[user]'),
        );
        $form['token_settings']['user_token_help'] = array(
          '#type' => 'fieldset',
          '#title' => t('Replacement patterns'),
          '#collapsible' => TRUE,
          '#collapsed' => TRUE,
        );
        $form['token_settings']['user_token_help']['user_help'] = array(
          '#value' => theme('token_help', 'user'),
        );
      }
      if ($link_types->isEnabled('auto_term')) {
        $form['token_settings']['taxonomy_title'] = array(
          '#type' => 'textfield',
          '#title' => t('Pattern replacement for taxonomy term links'),
          '#default_value' => $this->get('taxonomy_title', '[term]'),
        );
        $form['token_settings']['taxonomy_token_help'] = array(
          '#type' => 'fieldset',
          '#title' => t('Replacement patterns'),
          '#collapsible' => TRUE,
          '#collapsed' => TRUE,
        );
        $form['token_settings']['taxonomy_token_help']['taxonomy_help'] = array(
          '#value' => theme('token_help', 'taxonomy'),
        );
      }
    }

    $form['global'] = array(
      '#type' => 'fieldset',
      '#title' => t('Global link generation'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
      '#description' => t('Global settings allow site administrators more control over '.
                          'the location and frequency of link generation in node content.'),
    );
    $form['global']['link_limit'] = array(
      '#type' => 'select',
      '#title' => t('Limit links per keyword per node'),
      '#options' => array(
        'all' => 'all',
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
      ),
      '#default_value' => $this->get('link_limit', 'all'),
      '#description' => t('Providing a maximum number of links allowed will ensure that only that number '.
                          'of links for a given keyword will be generated per node.'),
    );
    $form['global']['total_link_limit'] = array(
      '#type' => 'select',
      '#title' => t('Limit total links per node'),
      '#options' => array(
        'all' => 'all',
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '11' => '11',
        '12' => '12',
        '13' => '13',
        '14' => '14',
        '15' => '15',
        '16' => '16',
        '17' => '17',
        '18' => '18',
        '19' => '19',
        '20' => '20',
      ),
      '#default_value' => $this->get('total_link_limit', 'all'),
      '#descrption' => t('Limit the total number of links that Autolink will generate on any individual node.'),
    );
    $form['attributes'] = array(
      '#type' => 'fieldset',
      '#title' => t('Link attributes'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
      '#description' => t('Default settings will be used to populate new link definition forms and '.
                          'when generating links in node content.'),
    );
    $form['attributes']['case_sensitivity'] = array(
      '#type' => 'checkbox',
      '#title' => t('Case-sensitivity'),
      '#default_value' => $this->get('case_sensitivity'),
      '#description' => t('Keywords will only be replaced with links if they match the case of the keyword.'),
    );
    $form['attributes']['style'] = array(
      '#type' => 'textfield',
      '#title' => t('Style'),
      '#default_value' => $this->get('style', ''),
      '#description' => t('Although it is recommended that you use a stylesheet and class, inline styles may '.
                          'be used for additional link attributes.'),
    );
    $form['attributes']['class'] = array(
      '#type' => 'textfield',
      '#title' => t('Class'),
      '#default_value' => $this->get('class', ''),
      '#description' => t('New link definitions can automatically be assigned classes. To assign more than '.
                          'one class enter a space separated list.'),
    );
    $form['attributes']['target'] = array(
      '#type' => 'select',
      '#title' => t('Target'),
      '#options' => array(
        'none' => 'none',
        '_blank' => '_blank',
        '_parent' => '_parent',
        '_self' => '_self',
        '_top' => '_top',
      ),
      '#default_value' => $this->get('target', 'none'),
      '#description' => t('Specifies where to open internally linked documents.'),
    );
    return $form;
  }
}
