<?php

/**
 * @file
 * Defines the Autolink automatic linking plugin for the Autolink Auto-linking module.
 */

/**
 * Defines the Autolink automatic linking plugin class.
 */
class AutolinkAutoPlugin extends AutolinkPlugin {

  /**
   * Returns an array of fields to be processed.
   */
  function getFields($type) {
    return array('body', 'teaser');
  }

  /**
   * Returns the case sensitivity of a link.
   */
  function getCase(AutolinkLink $link) {
    return $this->config->get('case_sensitivity', 0) == 1;
  }

  /**
   * Sets a limit on link generation per node.
   */
  function getTotalLimit() {
    return $this->config->get('total_link_limit', AUTOLINK_DEFAULT_LIMIT);
  }

  /**
   * Sets a limit on a per-link per-node basis.
   *
   * This method is set to ABSOLUTE in plugin info, so it cannot be
   * overridden without first altering plugin information.
   */
  function getLinkLimit() {
    return $this->config->get('link_limit', AUTOLINK_DEFAULT_LIMIT);
  }

  /**
   * Returns an array to prepend and append to the Autolink regular expression.
   */
  function getExpression(AutolinkLink $link) {
    return array('prepend' => '\b', 'append' => '\b');
  }

  /**
   * Returns the text of all links for the plugin. This method is set
   * to ABSOLUTE, so it cannot be overridden without altering plugin info.
   */
  function getText(AutolinkLink $link, $match) {
    return $match;
  }

  /**
   * Returns attributes for a link.
   *
   * This method is set to ENABLED in plugin info, so it may be overridden
   * by link types.
   */
  function getAttributes(AutolinkLink $link) {
    if (method_exists($link, 'getAttributes')) {
      return $link->getAttributes();
    }
    return array(
      'title' => $link->get('keyword'),
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }
}
