<?php

/**
 * @file
 * Administrative forms for the Autolink Default Plugin module.
 */

/**
 * Defines the configuration form class.
 */
class AutolinkConfigFormDefault extends AutolinkConfigForm {

  /**
   * Defines the configuration form.
   */
  protected function form(&$form_state, $settings) {
    $link_types = $this->fetchArraySetting('link_types');
    // Add pattern processing with Token for link titles.
    if (module_exists('token') && ($link_types->isEnabled('node') || $link_types->isEnabled('user') || $link_types->isEnabled('taxonomy'))) {
      $form['token_settings'] = array(
        '#type' => 'fieldset',
        '#title' => t('Token replacement patterns'),
        '#collapsible' => TRUE,
      );
  
      if ($link_types->isEnabled('node')) {
        $form['token_settings']['node_title'] = array(
          '#type' => 'textfield',
          '#title' => t('Pattern replacement for node links'),
          '#default_value' => $this->get('node_title', '[title]'),
          '#description' => t('Title patterns are used to generate link text when generating '.
                              'links in blocks or as part of the <i>title</i> attribute in links '.
                              'that are generated in node content.'),
        );
        $form['token_settings']['node_token_help'] = array(
          '#type' => 'fieldset',
          '#title' => t('Replacement patterns'),
          '#collapsible' => TRUE,
          '#collapsed' => TRUE,
        );
        $form['token_settings']['node_token_help']['node_help'] = array(
          '#value' => theme('token_help', 'node'),
        );
      }
  
      if ($link_types->isEnabled('user')) {
        $form['token_settings']['user_title'] = array(
          '#type' => 'textfield',
          '#title' => t('Pattern replacement for user links'),
          '#default_value' => $this->get('user_title', '[user]'),
        );
        $form['token_settings']['user_token_help'] = array(
          '#type' => 'fieldset',
          '#title' => t('Replacement patterns'),
          '#collapsible' => TRUE,
          '#collapsed' => TRUE,
        );
        $form['token_settings']['user_token_help']['user_help'] = array(
          '#value' => theme('token_help', 'user'),
        );
      }
      if ($link_types->isEnabled('taxonomy')) {
        $form['token_settings']['taxonomy_title'] = array(
          '#type' => 'textfield',
          '#title' => t('Pattern replacement for taxonomy term links'),
          '#default_value' => $this->get('taxonomy_title', '[term]'),
        );
        $form['token_settings']['taxonomy_token_help'] = array(
          '#type' => 'fieldset',
          '#title' => t('Replacement patterns'),
          '#collapsible' => TRUE,
          '#collapsed' => TRUE,
        );
        $form['token_settings']['taxonomy_token_help']['taxonomy_help'] = array(
          '#value' => theme('token_help', 'taxonomy'),
        );
      }
    }
  
    if ($link_types->isEnabled('node')) {
      $form['general_settings']['link_tagging'] = array(
        '#type' => 'checkbox',
        '#title' => t('Enable link tagging on node edit forms'),
        '#default_value' => $this->get('link_tagging'),
        '#description' => t('With link tagging enabled, link definitions that link to a given node '.
                            'can be managed from the node edit form. This setting only applies to '.
                            '<i>node</i> links.'),
      );
    }
  
    $form['global'] = array(
      '#type' => 'fieldset',
      '#title' => t('Link generation limits'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
      '#description' => t('Affords site administrators more control over frequency of link generation in content.'),
    );
    $form['global']['link_limit'] = array(
      '#type' => 'select',
      '#title' => t('Limit links per keyword per node'),
      '#options' => array(
        'all' => 'all',
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
      ),
      '#default_value' => $this->get('link_limit', 'all'),
      '#description' => t('Providing a maximum number of links allowed will ensure that only that number '.
                          'of links for a given keyword will be generated per node.'),
    );
    $form['global']['total_link_limit'] = array(
      '#type' => 'select',
      '#title' => t('Limit total links per node'),
      '#options' => array(
        'all' => 'all',
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '11' => '11',
        '12' => '12',
        '13' => '13',
        '14' => '14',
        '15' => '15',
        '16' => '16',
        '17' => '17',
        '18' => '18',
        '19' => '19',
        '20' => '20',
      ),
      '#default_value' => $this->get('total_link_limit', 'all'),
      '#descrption' => t('Limit the total number of links that Autolink will generate on any individual node.'),
    );
  
    // Default link settings.
    $form['attributes'] = array(
      '#type' => 'fieldset',
      '#title' => t('Link attributes'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
      '#description' => t('Default settings will be used to populate new link definition forms and '.
                          'when generating links in node content.'),
    );
    $form['attributes']['case_sensitivity'] = array(
      '#type' => 'checkbox',
      '#title' => t('Case-sensitivity'),
      '#default_value' => $this->get('case_sensitivity'),
      '#description' => t('Keywords will only be replaced with links if they match the case of the keyword. '.
                          'This setting serves only as a default, as the case-sensitivity attribute can '.
                          'be managed on a link-by-link basis on the link add/edit form.'),
    );
    $form['attributes']['style'] = array(
      '#type' => 'textfield',
      '#title' => t('Style'),
      '#default_value' => $this->get('style', ''),
      '#description' => t('Although it is recommended that you use a stylesheet and class, inline styles may '.
                          'be used for additional link attributes.'),
    );
    $form['attributes']['class'] = array(
      '#type' => 'textfield',
      '#title' => t('Class'),
      '#default_value' => $this->get('class', ''),
      '#description' => t('New link definitions can automatically be assigned classes. To assign more than '.
                          'one class enter a space separated list.'),
    );
    $form['attributes']['internal_target'] = array(
      '#type' => 'select',
      '#title' => t('Target (internal links)'),
      '#options' => array(
        'none' => 'none',
        '_blank' => '_blank',
        '_parent' => '_parent',
        '_self' => '_self',
        '_top' => '_top',
      ),
      '#default_value' => $this->get('internal_target', 'none'),
      '#description' => t('Specifies where to open internally linked documents.'),
    );
    $form['attributes']['external_target'] = array(
      '#type' => 'select',
      '#title' => t('Target (external links)'),
      '#options' => array(
        'none' => 'none',
        '_blank' => '_blank',
        '_parent' => '_parent',
        '_self' => '_self',
        '_top' => '_top',
      ),
      '#default_value' => $this->get('external_target', '_blank'),
      '#description' => t('Specifies where to open externally linked documents.'),
    );
    $form['attributes']['external_relationship'] = array(
      '#type' => 'checkbox',
      '#title' => t('Set <i>rel</i> attribute to <i>nofollow</i> for external links'),
      '#default_value' => $this->get('external_relationship'),
    );
    return $form;
  }
}
