<?php

/**
 * @file
 * Defines administrative form classes for Autolink Brackets Plugin.
 */

/**
 * Defines the configuration class.
 */
class AutolinkConfigFormPattern extends AutolinkConfigForm {

  /**
   * Defines the settings form.
   */
  protected function form(&$form_state, $settings) {
    $form['pattern_links'] = array(
      '#type' => 'fieldset',
      '#title' => t('Drupal.org style links plugin'),
      '#collapsible' => TRUE,
    );
    $form['pattern_links']['node_types'] = array(
      '#type' => 'checkboxes',
      '#title' => t('Destination content types'),
      '#options' => node_get_types('names'),
      '#default_value' => array_keys($this->getSettings('node_types', node_get_types('names'))),
      '#description' => t('Select the node types to which may be linked to via bracket style links.'),
    );

    $form['pattern_links']['search'] = array(
      '#type' => 'textfield',
      '#title' => t('Search pattern'),
      '#default_value' => $this->get('search', AUTOLINK_PATTERN_PATTERN),
      '#description' => t('Enter the pattern to search for. Use token replacements to indicate node attributes.'),
    );
    $form['pattern_links']['replace'] = array(
      '#type' => 'textfield',
      '#title' => t('Link pretext'),
      '#default_value' => $this->get('replace', AUTOLINK_PATTERN_REPLACEMENT),
      '#description' => t('Enter text with which the pattern should be replaced. Supports token pattern substitutions.'),
    );
    $form['pattern_links']['token_settings']['node_token_help'] = array(
      '#type' => 'fieldset',
      '#title' => t('Replacement patterns'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['pattern_links']['token_settings']['node_token_help']['node_help'] = array(
      '#value' => theme('token_help', 'node'),
    );

    $form['attributes'] = array(
      '#type' => 'fieldset',
      '#title' => t('Link attributes'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
      '#description' => t('Default settings will be used to populate new link definition forms and '.
                          'when generating links in node content.'),
    );
    $form['attributes']['style'] = array(
      '#type' => 'textfield',
      '#title' => t('Style'),
      '#default_value' => $this->get('style', ''),
      '#description' => t('Although it is recommended that you use a stylesheet and class, inline styles may '.
                          'be used for additional link attributes.'),
    );
    $form['attributes']['class'] = array(
      '#type' => 'textfield',
      '#title' => t('Class'),
      '#default_value' => $this->get('class', ''),
      '#description' => t('New link definitions can automatically be assigned classes. To assign more than '.
                          'one class enter a space separated list.'),
    );
    $form['attributes']['target'] = array(
      '#type' => 'select',
      '#title' => t('Target'),
      '#options' => array(
        'none' => 'none',
        '_blank' => '_blank',
        '_parent' => '_parent',
        '_self' => '_self',
        '_top' => '_top',
      ),
      '#default_value' => $this->get('target', 'none'),
      '#description' => t('Specifies where to open internally linked documents.'),
    );
    return $form;
  }
}
