<?php

/**
 * @file
 * Defines link type classes for Autolink Brackets Plugin module.
 */

/**
 * Defines the bracket link type provider class.
 */
class AutolinkPatternProvider extends AutolinkProvider {

  /**
   * Provides bracket style links to Autolink.
   */
  function provideLinks($type) {
    $nodes = array();
    $types = $this->config->fetchArraySetting('node_types')->getEnabled();
    if (!empty($types)) {
      $pattern = $this->config->get('search', AUTOLINK_PATTERN_PATTERN);
      $result = db_query('SELECT nid FROM {node} WHERE type IN ('. db_placeholders($types) .')', $types);
      while ($nid = db_result($result)) {
        $node = node_load($nid);
        $nodes[$node->nid] = array(
          'keyword' => token_replace($pattern, 'node', $node),
          'path' => "node/{$node->nid}",
          'nid' => $node->nid,
        );
      }
    }
    return $nodes;
  }
}
