<?php

/**
 * @file
 * Defines the Autolink Bracket Links Plugin class.
 */

/**
 * Defines the plugin.
 */
class AutolinkPatternPlugin extends AutolinkPlugin {

  /**
   * Returns link attributes. The title is based on token patterns if enabled.
   */
  function getAttributes(AutolinkLink $link) {
    $node = node_load($link->get('nid'));
    $title = !empty($node) ? $node->title : '';

    return array(
      'title' => $title,
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }

  /**
   * Returns the node title as stored in the bracket link object.
   */
  function getText(AutolinkLink $link, $match) {
    $node = node_load($link->get('nid'));
    if ($node) {
      $pattern = $this->config->get('replace', AUTOLINK_PATTERN_REPLACEMENT);
      return !empty($pattern) ? token_replace($pattern, 'node', $node) : $match; 
    }
    return $match;
  }

}
