<?php

/**
 * @file
 * Defines administrative form classes for Autolink Brackets Plugin.
 */

/**
 * Defines the configuration class.
 */
class AutolinkConfigFormPattern extends AutolinkConfigForm {

  /**
   * Defines the settings form.
   */
  protected function form(&$form_state, $settings) {
    $form['pattern_links'] = array(
      '#type' => 'fieldset',
      '#title' => t('Pattern based links plugin'),
      '#collapsible' => TRUE,
    );
    $form['pattern_links']['linkable_node_types'] = array(
      '#type' => 'checkboxes',
      '#title' => t('Enable pattern links by content type'),
      '#options' => node_get_types('names'),
      '#default_value' => array_keys($this->getSettings('linkable_node_types', node_get_types('names'))),
      '#description' => t('Limit pattern based linking by content type.'),
    );
    $form['node_patterns'] = array(
      '#type' => 'fieldset',
      '#title' => t('Node based patterns'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['node_patterns']['node_pattern_links'] = array(
      '#type' => 'checkbox',
      '#title' => t('Enable node pattern based links'),
      '#default_value' => $this->get('node_pattern_links', 1),
    );
    $form['node_patterns']['node_types'] = array(
      '#type' => 'checkboxes',
      '#title' => t('Destination content types'),
      '#options' => node_get_types('names'),
      '#default_value' => array_keys($this->getSettings('node_types', node_get_types('names'))),
      '#description' => t('Select the node types to which may be linked to via bracket style links.'),
    );
    $form['node_patterns']['node_search'] = array(
      '#type' => 'textfield',
      '#title' => t('Search pattern'),
      '#default_value' => $this->get('node_search', AUTOLINK_PATTERN_NODE),
      '#description' => t('Enter the pattern to search for. Use token replacements to indicate node attributes.'),
    );
    $form['node_patterns']['node_replace'] = array(
      '#type' => 'textfield',
      '#title' => t('Replacement pattern'),
      '#default_value' => $this->get('node_replace', AUTOLINK_PATTERN_REPLACE_NODE),
      '#description' => t('Enter text with which the pattern should be replaced. Supports token pattern substitutions.'),
    );
    $form['node_patterns']['token_settings']['node_token_help'] = array(
      '#type' => 'fieldset',
      '#title' => t('Replacement patterns'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['node_patterns']['token_settings']['node_token_help']['node_help'] = array(
      '#value' => theme('token_help', 'node'),
    );
    $form['user_patterns'] = array(
      '#type' => 'fieldset',
      '#title' => t('User based patterns'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['user_patterns']['user_pattern_links'] = array(
      '#type' => 'checkbox',
      '#title' => t('Enable user pattern based links'),
      '#default_value' => $this->get('user_pattern_links', 1),
    );
    $form['user_patterns']['user_search'] = array(
      '#type' => 'textfield',
      '#title' => t('Search pattern'),
      '#default_value' => $this->get('user_search', AUTOLINK_PATTERN_USER),
      '#description' => t('Enter the pattern to search for. Use token replacements to indicate node attributes.'),
    );
    $form['user_patterns']['user_replace'] = array(
      '#type' => 'textfield',
      '#title' => t('Replacement pattern'),
      '#default_value' => $this->get('user_replace', AUTOLINK_PATTERN_REPLACE_USER),
      '#description' => t('Enter text with which the pattern should be replaced. Supports token pattern substitutions.'),
    );
    $form['user_patterns']['user_token_settings']['user_token_help'] = array(
      '#type' => 'fieldset',
      '#title' => t('Replacement patterns'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['user_patterns']['user_token_settings']['user_token_help']['user_help'] = array(
      '#value' => theme('token_help', 'user'),
    );
    $form['term_patterns'] = array(
      '#type' => 'fieldset',
      '#title' => t('Taxonomy term based patterns'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['term_patterns']['term_pattern_links'] = array(
      '#type' => 'checkbox',
      '#title' => t('Enable taxonomy term pattern based links'),
      '#default_value' => $this->get('term_pattern_links', 1),
    );
    $form['term_patterns']['term_search'] = array(
      '#type' => 'textfield',
      '#title' => t('Search pattern'),
      '#default_value' => $this->get('term_search', AUTOLINK_PATTERN_TERM),
      '#description' => t('Enter the pattern to search for. Use token replacements to indicate node attributes.'),
    );
    $form['term_patterns']['term_replace'] = array(
      '#type' => 'textfield',
      '#title' => t('Replacement pattern'),
      '#default_value' => $this->get('term_replace', AUTOLINK_PATTERN_REPLACE_TERM),
      '#description' => t('Enter text with which the pattern should be replaced. Supports token pattern substitutions.'),
    );
    $form['term_patterns']['taxonomy_token_settings']['taxonomy_token_help'] = array(
      '#type' => 'fieldset',
      '#title' => t('Replacement patterns'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['term_patterns']['taxonomy_token_settings']['taxonomy_token_help']['taxonomy_help'] = array(
      '#value' => theme('token_help', 'taxonomy'),
    );

    $form['attributes'] = array(
      '#type' => 'fieldset',
      '#title' => t('Link attributes'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
      '#description' => t('Default settings will be used to populate new link definition forms and '.
                          'when generating links in node content.'),
    );
    $form['attributes']['node_title'] = array(
      '#type' => 'textfield',
      '#title' => t('Node link <i>title</i> attribute pattern'),
      '#default_value' => $this->get('node_title', '[title]'),
      '#description' => t('Enter a Token pattern for building the <i>title</i> attribute of links to nodes.'),
    );
    $form['attributes']['user_title'] = array(
      '#type' => 'textfield',
      '#title' => t('User link <i>title</i> attribute pattern'),
      '#default_value' => $this->get('node_title', '[user]'),
      '#description' => t('Enter a Token pattern for building the <i>title</i> attribute of links to users.'),
    );
    $form['attributes']['term_title'] = array(
      '#type' => 'textfield',
      '#title' => t('Term link <i>title</i> attribute pattern'),
      '#default_value' => $this->get('term_title', '[cat]'),
      '#description' => t('Enter a Token pattern for building the <i>title</i> attribute of links to taxonomy terms.'),
    );
    $form['attributes']['style'] = array(
      '#type' => 'textfield',
      '#title' => t('Style'),
      '#default_value' => $this->get('style', ''),
      '#description' => t('Although it is recommended that you use a stylesheet and class, inline styles may '.
                          'be used for additional link attributes.'),
    );
    $form['attributes']['class'] = array(
      '#type' => 'textfield',
      '#title' => t('Class'),
      '#default_value' => $this->get('class', ''),
      '#description' => t('New link definitions can automatically be assigned classes. To assign more than '.
                          'one class enter a space separated list.'),
    );
    $form['attributes']['target'] = array(
      '#type' => 'select',
      '#title' => t('Target'),
      '#options' => array(
        'none' => 'none',
        '_blank' => '_blank',
        '_parent' => '_parent',
        '_self' => '_self',
        '_top' => '_top',
      ),
      '#default_value' => $this->get('target', 'none'),
      '#description' => t('Specifies where to open internally linked documents.'),
    );
    return $form;
  }
}
