<?php

/**
 * @file
 * Defines link type classes for Autolink Brackets Plugin module.
 */

/**
 * Defines the bracket link type provider class.
 */
class AutolinkNodePatternProvider extends AutolinkProvider {

  /**
   * Provides bracket style links to Autolink.
   */
  function provideLinks($type) {
    $nodes = array();
    if ($this->config->get('node_pattern_links', 1) == 1) {
      $available = $this->config->fetchArraySetting('linkable_node_types')->getEnabled();
      if (in_array($type, $available)) {
        $types = $this->config->fetchArraySetting('node_types')->getEnabled();
        if (!empty($types)) {
          $query = array();
          foreach ($types as $type) {
            $query[] = "type = '$type'";
          }
          $pattern = $this->config->get('node_search', AUTOLINK_PATTERN_NODE);
          $result = db_query('SELECT nid FROM {node} WHERE '. implode(' OR ', $query) .'');
          while ($nid = db_result($result)) {
            $node = node_load($nid);
            $nodes[$node->nid] = array(
              'keyword' => token_replace($pattern, 'node', $node),
              'path' => "node/{$node->nid}",
              'nid' => $node->nid,
            );
          }
        }
      }
    }
    return $nodes;
  }

}

/**
 * Defines the term link class.
 */
class AutolinkPatternNodeLink extends AutolinkLink {

  /**
   * Returns link attributes.
   */
  function getAttributes() {
    $pattern = $this->config->get('node_title', '[title]');
    $node = node_load($this->get('nid'));
    $title = !empty($node) && !empty($pattern) ? token_replace($pattern, 'node', $node) : '';

    return array(
      'title' => $title,
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }

  /**
   * Returns the replacement text.
   */
  function getText($match) {
    $node = node_load($this->get('nid'));
    if ($node) {
      $pattern = $this->config->get('node_replace', AUTOLINK_PATTERN_REPLACE_NODE);
      return !empty($pattern) ? token_replace($pattern, 'node', $node) : $match; 
    }
    return $match;
  }
}

/**
 * Defines the bracket link type provider class.
 */
class AutolinkUserPatternProvider extends AutolinkProvider {

  /**
   * Provides bracket style links to Autolink.
   */
  function provideLinks($type) {
    $users = array();
    if ($this->config->get('user_pattern_links', 1) == 1) {
      $available = $this->config->fetchArraySetting('linkable_node_types')->getEnabled();
      if (in_array($type, $available)) {
        $pattern = $this->config->get('user_search', AUTOLINK_PATTERN_USER);
        $result = db_query('SELECT uid FROM {users}');
        while ($uid = db_result($result)) {
          $user = user_load(array('uid' => $uid));
          $users[$user->uid] = array(
            'keyword' => token_replace($pattern, 'user', $user),
            'path' => "user/{$user->uid}",
            'uid' => $user->uid,
          );
        }
      }
    }
    return $users;
  }

}

/**
 * Defines the term link class.
 */
class AutolinkPatternUserLink extends AutolinkLink {

  /**
   * Returns link attributes.
   */
  function getAttributes() {
    $pattern = $this->config->get('user_title', '[user]');
    $user = user_load($this->get('uid'));
    $title = !empty($user) && !empty($pattern) ? token_replace($pattern, 'user', $user) : '';

    return array(
      'title' => $title,
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }

  /**
   * Returns the replacement text.
   */
  function getText($match) {
    if ($user = user_load(array('uid' => $link->get('uid')))) {
      $pattern = $this->config->get('user_replace', AUTOLINK_PATTERN_REPLACE_USER);
      return !empty($pattern) ? token_replace($pattern, 'user', $user) : $match;
    }
    return $match;
  }
}

/**
 * Defines the bracket link type provider class.
 */
class AutolinkTermPatternProvider extends AutolinkProvider {

  /**
   * Provides bracket style links to Autolink.
   */
  function provideLinks($type) {
    $terms = array();
    if ($this->config->get('term_pattern_links', 1) == 1) {
      $available = $this->config->fetchArraySetting('linkable_node_types')->getEnabled();
      if (in_array($type, $available)) {
        $pattern = $this->config->get('term_search', AUTOLINK_PATTERN_TERM);
        $result = db_query('SELECT * FROM {term_data}');
        while ($term = db_fetch_object($result)) {
          $terms[$term->tid] = array(
            'keyword' => token_replace($pattern, 'taxonomy', $term),
            'path' => "taxonomy/term/{$term->tid}",
            'tid' => $term->tid,
          );
        }
      }
    }
    return $terms;
  }

}

/**
 * Defines the term link class.
 */
class AutolinkPatternTermLink extends AutolinkLink {

  /**
   * Returns link attributes.
   */
  function getAttributes() {
    $pattern = $this->config->get('term_title', '[cat]');
    $result = db_query('SELECT * FROM {term_data}');
    $term = db_fetch_object($result);
    $title = !empty($term) && !empty($pattern) ? token_replace($pattern, 'taxonomy', $term) : '';

    return array(
      'title' => $title,
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }

  /**
   * Returns the replacement text.
   */
  function getText($match) {
    $result = db_query("SELECT * FROM {term_data} WHERE tid = '%s'", $this->get('tid'));
    if ($term = db_fetch_object($result)) {
      $pattern = $this->config->get('term_replace', AUTOLINK_PATTERN_REPLACE_TERM);
      return !empty($pattern) ? token_replace($pattern, 'taxonomy', $term) : $match;
    }
    return $match;
  }
}
