<?php

/**
 * @file
 * Autolink hook implementations for the Autolink API.
 */

/**
 * Implements hook_autolink_plugin_info().
 */
function autolink_default_autolink_plugin_info() {
  $plugin['autolink'] = array(
    'label' => t('Keyword based links plugin'),
    'description' => t('Converts pre-defined keywords into links in content.'),
    'class' => 'AutolinkDefaultPlugin',
    'file' => 'includes/autolink_default.plugin.inc',
    'method' => 'filter',
    'link types' => array('external', 'node', 'user'),
    'config' => array('class' => 'AutolinkConfigFormDefault', 'file' => 'includes/autolink_default.admin.inc'),
  );
  if (module_exists('taxonomy')) {
    $plugin['autolink']['link types'][] = 'taxonomy';
  }
  if (module_exists('search')) {
    $plugin['autolink']['link types'][] = 'node_search';
    $plugin['autolink']['link types'][] = 'user_search';
  }
  return $plugin;
}

/**
 * Implements hook_autolink_link_type_info().
 */
function autolink_default_autolink_link_type_info() {
  $info = array();
  $defaults = array('identifiable' => AUTOLINK_ENABLED, 'definable' => AUTOLINK_ENABLED, 'file' => 'includes/autolink_default.link_types.inc');
  $file = array('file' => 'includes/autolink_default.forms.inc');
  $info['external'] = $defaults + array(
    'label' => t('External URL'),
    'class' => 'AutolinkDefaultLink',
    'config' => array(
      'path' => $file + array('label' => t('Enter a URL'), 'class' => 'AutolinkExternalForm'),
    ),
  );
  $info['node'] = $defaults + array(
    'label' => t('Link to node'),
    'class' => 'AutolinkNodeLink',
    'config' => array(
      'title' => $file + array('label' => t('Select content'), 'class' => 'AutolinkNodeTitleForm'),
      'path' => $file + array('label' => t('Enter a path'), 'class' => 'AutolinkNodePathForm'),
    ),
  );
  $info['user'] = $defaults + array(
    'label' => t('Link to user profile'),
    'class' => 'AutolinkUserLink',
    'config' => array(
      'select' => $file + array('label' => t('Select a user'), 'class' => 'AutolinkUserSelectForm'),
      'name' => $file + array('label' => t('Enter a user name'), 'class' => 'AutolinkUserNameForm'),
      'mail' => $file + array('label' => t('Enter a user e-mail'), 'class' => 'AutolinkUserMailForm'),
    ),
  );
  $info['taxonomy'] = $defaults + array(
    'label' => t('Taxonomy term'),
    'class' => 'AutolinkTermLink',
    'config' => array(
      'select' => $file + array('label' => t('Select a term'), 'class' => 'AutolinkTermSelectForm'),
      'multiple' => $file + array('label' => t('Enter comma separated terms'), 'class' => 'AutolinkTermMultipleForm'),
    ),
  );
  $info['node_search'] = $defaults + array(
    'label' => t('Content search results'),
    'class' => 'AutolinkDefaultLink',
    'config' => array(
      'node_search' => $file + array('label' => t('Content search'), 'class' => 'AutolinkNodeSearchForm'),
    ),
  );
  $info['user_search'] = $defaults + array(
    'label' => t('User search results'),
    'class' => 'AutolinkDefaultLink',
    'config' => array(
      'user_search' => $file + array('label' => t('User search'), 'class' => 'AutolinkUserSearchForm'),
    ),
  );
  return $info;
}
