<?php

/**
 * @file
 * Provides bulk link operations for the Autolink module.
 */

/**
 * Defines bulk link operations.
 */
function autolink_operations($form_state = array()) {
  return array(
    'delete' => array(
      'label' => t('Delete the selected link definitions'),
    ),
  );
}

/**
 * Delete confirmation form for link overview form.
 */
function autolink_link_multiple_delete_confirm(&$form_state) {
  $edit = $form_state['post'];

  $form['group'] = array('#type' => 'value', '#value' => $edit['group']);
  $form['links'] = array('#prefix' => '<ul>', '#suffix' => '</ul>', '#tree' => TRUE);
  // array_filter() returns only elements with TRUE values.
  foreach (array_filter($edit['links']) as $lid => $value) {
    $link = db_result(db_query('SELECT keyword FROM {autolink_link} WHERE lid = %d', $lid));
    $form['links'][$lid] = array('#type' => 'hidden', '#value' => $lid, '#prefix' => '<li>', '#suffix' => check_plain($link) ."</li>\n");
  }
  $form['operation'] = array('#type' => 'hidden', '#value' => 'delete');

  return confirm_form($form,
                      t('Are you sure you want to delete these link definitions?'),
                      'admin/settings/autolink', t('This action cannot be undone.'),
                      t('Delete all'), t('Cancel'));
}

/**
 * Submit handler for deleting link definitions from the link overview form.
 */
function autolink_link_multiple_delete_confirm_submit($form, &$form_state) {
  $group = $form_state['values']['group'];
  if ($form_state['values']['confirm']) {
    foreach ($form_state['values']['links'] as $lid => $value) {
      autolink_delete($lid);
    }
    drupal_set_message(t('The link definitions have been deleted.'));
  }
  $form_state['redirect'] = "admin/content/autolink/$group";
  return;
}
