<?php

/**
 * @file
 * Defines the CamelCase link type.
 */

/**
 * Defines the CamelCase link type provider class.
 */
class AutolinkCamelCaseProvider extends AutolinkProvider {

  /**
   * Provides CamelCase node links.
   */
  function provideLinks($node) {
    $nodes = array();
    $available = $this->config->fetchArraySetting('camelcase_node_types')->getEnabled();
    if (in_array($node->type, $available)) {
      $types = $this->config->fetchArraySetting('destination_node_types')->getEnabled();
      if (!empty($types)) {
        $query = array();
        foreach ($types as $type) {
          $query[] = "n.type = '$type'";
        }
        $result = db_query('SELECT n.*, r.* FROM {node} n INNER JOIN {node_revisions} r ON r.nid = n.nid WHERE '. implode(' OR ', $query));
        while ($dest = db_fetch_object($result)) {
          $parts = explode(' ', preg_replace('/[^a-zA-Z0-9-\s]/', '', $dest->title));
          $words = array_map('drupal_ucfirst', $parts);
          $nodes[$dest->nid] = array(
            'keyword' => implode('', $words),
            'path' => "node/{$node->nid}",
            'node' => $dest,
          );
        }
      }
    }
    return $nodes;
  }

}

/**
 * Defines the CamelCase link type class.
 */
class AutolinkCamelCaseLink extends AutolinkLink {

  /**
   * Returns link attributes.
   */
  function getAttributes() {
    $pattern = $this->config->get('node_title', '[title]');
    $node = $this->get('node');
    $title = !empty($node) && !empty($pattern) ? token_replace($pattern, 'node', $node) : '';

    return array(
      'title' => $title,
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }

}
