<?php

/**
 * @file
 * Defines the Autolink Pattern based links Plugin class.
 */

/**
 * Pattern based links allow the link types to handle operations.
 */
class AutolinkPatternPlugin extends AutolinkPlugin {

  /**
   * Returns regular expression characters.
   */
  function getExpression(AutolinkLink $link) {
    // Get the setting object based on the link type.
    $left = $right = '';
    $parts = explode('_', $link->getType());
    $setting = $parts[0] .'_boundaries';
    $boundaries = $this->config->fetchArraySetting($setting);
    if ($boundaries->isEnabled('left')) {
      $left = '\b';
    }
    if ($boundaries->isEnabled('right')) {
      $right = '\b';
    }
    return array('prepend' => $left, 'append' => $right);
  }

  /**
   * Returns link attributes. The title is based on token patterns if enabled.
   */
  function getAttributes(AutolinkLink $link) {
    return $link->getAttributes();
  }

  /**
   * Returns the node title as stored in the bracket link object.
   */
  function getText(AutolinkLink $link, $match) {
    return $link->getText($match);
  }

}
