<?php

/**
 * @file
 * Plugins for Autolink Pattern Links plugin.
 */

/**
 * Replace callback for node links.
 */
function autolink_pattern_node_replace($match, $settings) {
  $parts = explode(':', trim($match, '[]'));
  if ($parts[0] == 'title' && !empty($settings['patterns']['node_title']) && $node = _autolink_pattern_get_node('title', $parts[1])) {
    $item = array(
      'title' => token_replace($settings['title'], 'node', $node),
      'class' => isset($settings['class']) ? $settings['class'] : '',
      'style' => isset($settings['style']) ? $settings['style'] : '',
      'target' => isset($settings['target']) ? $settings['target'] : 'none',
    );
    return autolink_pattern_get_link($item, $node->title, 'node/' . $node->nid, $settings);
  }
  elseif ($parts[0] == 'node-id' && !empty($settings['patterns']['node_id']) && $node = _autolink_pattern_get_node('nid', $parts[1])) {
    $item = array(
      'title' => token_replace($settings['title'], 'node', $node),
      'class' => isset($settings['class']) ? $settings['class'] : '',
      'style' => isset($settings['style']) ? $settings['style'] : '',
      'target' => isset($settings['target']) ? $settings['target'] : 'none',
    );
    return autolink_pattern_get_link($item, $node->title, 'node/' . $node->nid, $settings);
  }
}

/**
 * Returns a node object based on pattern parameters.
 */
function _autolink_pattern_get_node($field, $value) {
  $node = db_fetch_object(db_query("SELECT * FROM {node} WHERE $field = '%s'", $value));
  return !empty($node) ? $node : FALSE;
}

/**
 * Replace callback for node links.
 */
function autolink_pattern_user_replace($match, $settings) {
  $parts = explode(':', trim($match, '[]'));
  if ($parts[0] == 'user' && !empty($settings['patterns']['user_name']) && $user = user_load(array('name' => $parts[1]))) {
    $item = array(
      'title' => token_replace($settings['title'], 'user', $user),
      'class' => isset($settings['class']) ? $settings['class'] : '',
      'style' => isset($settings['style']) ? $settings['style'] : '',
      'target' => isset($settings['target']) ? $settings['target'] : 'none',
    );
    return autolink_pattern_get_link($item, $user->name, 'user/' . $user->uid, $settings);
  }
  elseif ($parts[0] == 'user-id' && !empty($settings['patterns']['user_id']) && $user = user_load(array('uid' => $parts[1]))) {
    $item = array(
      'title' => token_replace($settings['title'], 'user', $user),
      'class' => isset($settings['class']) ? $settings['class'] : '',
      'style' => isset($settings['style']) ? $settings['style'] : '',
      'target' => isset($settings['target']) ? $settings['target'] : 'none',
    );
    return autolink_pattern_get_link($item, $user->name, 'user/' . $user->uid, $settings);
  }
}

/**
 * Replace callback for node links.
 */
function autolink_pattern_term_replace($match, $settings) {
  $parts = explode(':', trim($match, '[]'));
  if ($parts[0] == 'term' && !empty($settings['patterns']['term_name']) && $term = _autolink_pattern_get_term('name', $parts[1])) {
    $item = array(
      'title' => token_replace($settings['title'], 'taxonomy', $term),
      'class' => isset($settings['class']) ? $settings['class'] : '',
      'style' => isset($settings['style']) ? $settings['style'] : '',
      'target' => isset($settings['target']) ? $settings['target'] : 'none',
    );
    return autolink_pattern_get_link($item, $term->name, 'taxonomy/term/' . $term->tid, $settings);
  }
  elseif ($parts[0] == 'term-id' && !empty($settings['patterns']['term_id']) && $term = _autolink_pattern_get_term('tid', $parts[1])) {
    $item = array(
      'title' => token_replace($settings['title'], 'taxonomy', $term),
      'class' => isset($settings['class']) ? $settings['class'] : '',
      'style' => isset($settings['style']) ? $settings['style'] : '',
      'target' => isset($settings['target']) ? $settings['target'] : 'none',
    );
    return autolink_pattern_get_link($item, $term->name, 'taxonomy/term/' . $term->tid, $settings);
  }
}

/**
 * Returns a node object based on pattern parameters.
 */
function _autolink_pattern_get_term($field, $value) {
  $term = db_fetch_object(db_query("SELECT * FROM {term_data} WHERE $field = '%s'", $value));
  return !empty($term) ? $term : FALSE;
}

/**
 * Search link replacement callback.
 */
function autolink_pattern_search_replace($match, $settings) {
  $parts = explode(':', trim($match, '[]'));
  if (isset($parts[1])) {
    if ($parts[0] == 'search' && !empty($settings['node'])) {
      return autolink_pattern_get_link(array(
        'title' => $parts[1],
        'class' => isset($settings['class']) ? $settings['class'] : '',
        'style' => isset($settings['style']) ? $settings['style'] : '',
        'target' => isset($settings['target']) ? $settings['target'] : 'none',
      ),
      $parts[1], 'search/node/' . check_plain($parts[1]), $settings, TRUE);
    }
    elseif ($parts[0] == 'google' && !empty($settings['google'])) {
      return autolink_pattern_get_link(array(
        'title' => $parts[1],
        'class' => isset($settings['class']) ? $settings['class'] : '',
        'style' => isset($settings['style']) ? $settings['style'] : '',
        'target' => isset($settings['target']) ? $settings['target'] : 'none',
      ),
      $parts[1], 'search/node/' . check_plain($parts[1]), $settings, TRUE);
    }
  }
}

/**
 * Preprocesses the node links processor.
 */
function autolink_pattern_node_token_preprocess(AutolinkProcessor $processor, $settings, $node, AutolinkCache $cache) {
  if (autolink_pattern_prepare_processor($processor, $settings)) {

    if ($items = $cache->get_items($node->type)) {
      $processor->add_items($items->data);
    }
    elseif (isset($settings['node_types']) && in_array($node->type, $settings['node_types']) && !empty($settings['destination_node_types'])) {
      $query = array();
      foreach ($settings['destination_node_types'] as $type) {
        $query[] = "n.type = '$type'";
      }
  
      $pattern = isset($settings['node_search']) ? $settings['node_search'] : AUTOLINK_PATTERN_NODE;
  
      $items = array();
      $result = db_query('SELECT n.*, r.* FROM {node} n INNER JOIN {node_revisions} r ON r.nid = n.nid WHERE '. implode(' OR ', $query));
      while ($dest = db_fetch_object($result)) {
        $items = array(
          'search' => token_replace($pattern, 'node', $dest),
          'node' => $dest,
        );
      }
      $processor->add_items($items);
      $cache->set_items($node->type, $items);
    }
  }
}

/**
 * Returns a replacement for matched node links.
 */
function autolink_pattern_node_token_replace($match, $settings, $item = array()) {
  $replacement = token_replace(isset($settings['node_replace']) ? $settings['node_replace'] : AUTOLINK_PATTERN_REPLACE_NODE, 'node', $item['node']);
  $item += array(
    'title' => $item['node']->title,
    'class' => isset($settings['class']) ? $settings['class'] : '',
    'style' => isset($settings['style']) ? $settings['style'] : '',
    'target' => isset($settings['target']) ? $settings['target'] : 'none',
  );

  return autolink_pattern_get_link($item, $replacement, 'node/' . $item['node']->nid, $settings);
}

/**
 * Preprocesses the user links processor.
 */
function autolink_pattern_user_token_preprocess(AutolinkProcessor $processor, $settings, $node, AutolinkCache $cache) {
  if (autolink_pattern_prepare_processor($processor, $settings)) {

    if ($items = $cache->get_items($node->type)) {
      $processor->add_items($items->data);
    }
    elseif (isset($settings['node_types']) && in_array($node->type, $settings['node_types']) && !empty($settings['user_roles'])) {
      $query = array();
      foreach ($roles as $rid) {
        $query[] = "r.rid = $rid";
      }
  
      $pattern = isset($settings['user_search']) ? $settings['user_search'] : AUTOLINK_PATTERN_USER;
  
      $items = array();
      $result = db_query('SELECT u.* FROM {users} u LEFT JOIN {users_roles} r ON u.uid = r.uid WHERE u.uid <> 0 AND '. implode(' OR ', $query));
      while ($user = db_fetch_object($result)) {
        $items = array(
          'search' => token_replace($pattern, 'user', $user),
          'user' => $user,
        );
      }
      $processor->add_items($items);
      $cache->set_items($node->type, $items);
    }
  }
}

/**
 * Returns a replacement for matched node links.
 */
function autolink_pattern_user_token_replace($match, $settings, $item = array()) {
  $replacement = token_replace(isset($settings['user_replace']) ? $settings['user_replace'] : AUTOLINK_PATTERN_REPLACE_USER, 'user', $item['user']);
  $item += array(
    'title' => $item['user']->name,
    'class' => isset($settings['class']) ? $settings['class'] : '',
    'style' => isset($settings['style']) ? $settings['style'] : '',
    'target' => isset($settings['target']) ? $settings['target'] : 'none',
  );

  return autolink_pattern_get_link($item, $replacement, 'user/' . $item['user']->uid, $settings);
}

/**
 * Preprocesses the user links processor.
 */
function autolink_pattern_term_token_preprocess(AutolinkProcessor $processor, $settings, $node, AutolinkCache $cache) {
  autolink_pattern_prepare_processor($processor, $settings);

  if ($items = $cache->get_items($node->type)) {
    $processor->add_items($items->data);
  }
  elseif (isset($settings['node_types']) && in_array($node->type, $settings['node_types']) && !empty($settings['vocabularies'])) {
    $query = array();
    foreach ($vocabularies as $vid) {
      $query[] = "vid = '$vid'";
    }

    $pattern = isset($settings['term_search']) ? $settings['term_search'] : AUTOLINK_PATTERN_TERM;

    $items = array();
    $result = db_query('SELECT * FROM {term_data} WHERE '. implode(' OR ', $query));
    while ($term = db_fetch_object($result)) {
      $items = array(
        'search' => token_replace($pattern, 'taxonomy', $term),
        'term' => $term,
      );
    }
    $processor->add_items($items);
    $cache->set_items($node->type, $items);
  }
}

/**
 * Returns a replacement for matched node links.
 */
function autolink_pattern_term_token_replace($match, $settings, $item = array()) {
  $replacement = token_replace(isset($settings['term_replace']) ? $settings['term_replace'] : AUTOLINK_PATTERN_REPLACE_TERM, 'taxonomy', $item['term']);
  $item += array(
    'title' => $item['term']->name,
    'class' => isset($settings['class']) ? $settings['class'] : '',
    'style' => isset($settings['style']) ? $settings['style'] : '',
    'target' => isset($settings['target']) ? $settings['target'] : 'none',
  );

  return autolink_pattern_get_link($item, $replacement, 'taxonomy/term/' . $item['term']->tid, $settings);
}

/**
 * Prepares standard settings with settings that are standard across the plugin.
 */
function autolink_pattern_prepare_processor(AutolinkProcessor $processor, $settings) {
  if (in_array($node->type, $settings['node_types'])) {
    $processor->case = 0;
    $processor->expression = '/(?<!\\\\)\[(.+)]/i';
    $processor->validate_items = FALSE;

    $processor->set_total_limit($settings['total_limit']);
    $processor->set_item_limit($settings['item_limit']);
    return TRUE;
  }
  // Halt the processing for this plugin if the node type is not enabled.
  else {
    $processor->skip();
    return FALSE;
  }
}

/**
 * Returns a link based on settings.
 */
function autolink_pattern_get_link($item, $replacement, $path, $settings, $external = FALSE) {
  $options = array(
    'query' => $item['query'],
    'absolute' => TRUE,
    'alias' => FALSE,
    'external' => $external,
    'attributes' => !empty($item['attributes']) ? $item['attributes'] : '',
  );

  // Unset the empty attributes to avoid invalid markup and unnecessary attributes.
  if (!empty($options['attributes'])) {
    foreach ($options['attributes'] as $attribute => $value) {
      if (empty($value)) {
        unset($options['attributes'][$attribute]);
      }
    }
  }
  else {
    unset($options['attributes']);
  }

  // The target attribute causes _blank if 'none' is not unset.
  if ($options['attributes']['target'] == 'none') {
    unset($options['attributes']['target']);
  }

  return l($replacement, $path, $options);
}
