<?php

/**
 * @file
 * Administrative forms for the Autolink Markup plugin.
 */

/**
 * Page to edit markup.
 */
function autolink_markup_admin_markup_edit($format, $markup) {
  if ((isset($_POST['op']) && $_POST['op'] == t('Delete')) || isset($_POST['confirm'])) {
    return drupal_get_form('autolink_markup_confirm_markup_delete', $format, (array)$markup);
  }
  return drupal_get_form('autolink_markup_form_markup', $format, (array)$markup);
}

/**
 * Form for adding and editing markup rules.
 */
function autolink_markup_form_markup(&$form_state, $format, $settings = array()) {
  $form = array();
  $form['format'] = array('#type' => 'value', '#value' => $format);
  $form['help'] = array(
    '#value' => t('Markup patterns follow the format %pattern where %identifier is used to identify the pattern and %value is wrapped in the given markup.', array('%pattern' => '[identifier:[value]]', '%identifier' => 'identifier', '%value' => '[value]')),
  );
  $form['keyword'] = array(
    '#type' => 'textfield',
    '#title' => t('Identifier'),
    '#required' => TRUE,
    '#default_value' => isset($settings['keyword']) ? $settings['keyword'] : '',
    '#description' => t('The identifier is the text used in the prefix (before the colon : ) of the pattern to identify the particular markup you would like to use.'),
  );
  $form['markup'] = array(
    '#type' => 'textfield',
    '#title' => t('Markup'),
    '#default_value' => isset($settings['markup']) ? $settings['markup'] : AUTOLINK_MARKUP_DEFAULT,
    '#description' => t('Enter precise markup to generate around a pattern match. Use the token <strong>[value]</strong> to indicate the placement of the match within the markup.'),
  );

  $form['submit'] = array('#type' => 'submit', '#value' => t('Save'));
  if (isset($settings['mid'])) {
    $form['delete'] = array('#type' => 'submit', '#value' => t('Delete'));
    $form['mid'] = array('#type' => 'value', '#value' => $settings['mid']);
  }
  return $form;
}

/**
 * Validation callback for markup form.
 */
function autolink_markup_form_markup_validate($form, &$form_state) {
  if (!strstr($form_state['values']['markup'], '[value]')) {
    form_set_error('markup', t('Markup must contain the value token %value.', array('%value' => '[value]')));
  }
}

/**
 * Submit handler for the markup pattern form.
 */
function autolink_markup_form_markup_submit($form, &$form_state) {
  switch (autolink_markup_markup_save($form_state['values'])) {
    case SAVED_NEW:
      drupal_set_message(t('Created new markup pattern') . ' [' . $form_state['values']['keyword'] . ':[value]]');
      break;
    case SAVED_UPDATED:
      drupal_set_message(t('Updated markup pattern') . ' [' . $form_state['values']['keyword'] . ':[value]]');
      break;
  }
  drupal_goto('admin/settings/filters/' . $form_state['values']['format'] . '/autolink_markup/settings');
}

/**
 * Confirm form for deleting a markup pattern.
 */
function autolink_markup_confirm_markup_delete(&$form_state, $format, $markup) {
  if (is_object($markup)) {
    $markup = (array)$markup;
  }

  $form['format'] = array('#type' => 'value', '#value' => $format);
  $form['mid'] = array('#type' => 'value', '#value' => $markup['mid']);
  $form['keyword'] = array('#type' => 'value', '#value' => $markup['keyword']);
  return confirm_form($form,
                  t('Are you sure you want to delete the markup pattern?'),
                  "admin/settings/filters/$format/autolink_markup/settings",
                  t('This action cannot be undone.'),
                  t('Delete'),
                  t('Cancel'));
}

/**
 * Submit handler for markup pattern delete form.
 */
function autolink_markup_confirm_markup_delete_submit($form, &$form_state) {
  $status = autolink_markup_markup_delete($form_state['values']['mid']);
  drupal_set_message(t('Deleted markup pattern') . ' [' . $form_state['values']['keyword'] . ':[value]]');
  $form_state['redirect'] = "admin/settings/filters/{$form_state['values']['format']}/autolink_markup/settings";
  return;
}
