<?php

/**
 * @file
 * Provides filters for the groups overview page in Autolink administration.
 *
 * Filters:
 *   Content type.
 *   Status:
 *     -Active
 *     -Blocked
 */

/**
 * Build query for autolink admin filters based on session.
 */
function autolink_build_filter_query(SelectQuery $query) {
  $filters = autolink_filters();
  // Extend Query with filter conditions.
  foreach (isset($_SESSION['autolink_overview_filter']) ? $_SESSION['autolink_overview_filter'] : array() as $filter) {
    list($key, $value) = $filter;
    $query->condition($filters[$key]['field'], $value);
  }
}

/**
 * List autolink administration filters that can be applied.
 */
function autolink_filters() {
  foreach (module_invoke_all('autolink_filters') as $key => $filter) {
    $filters[$key] = $filter;
  }
  return $filters;
}

/**
 * Implements of hook_autolink_filters().
 */
function autolink_autolink_filters() {
  // Node type filters.
  $filters = array();
  $node_types = node_type_get_names();
  if (count($node_types)) {
    $filters['node_type'] = array(
      'title' => t('content type'),
      'where' => "t.node_type = '%s'",
      'options' => $node_types,
      'join' => '',
    );
  }

  // Status filters.
  $filters['status'] = array(
    'title' => t('status'),
    'where' => 'g.status = %d',
    'join' => '',
    'options' => array(1 => t('active'), 0 => t('disabled')),
  );

  return $filters;
}
