<?php

/**
 * @file
 * Defines the CamelCase link type.
 */

/**
 * Defines the CamelCase link type provider class.
 */
class AutolinkCamelCaseProvider extends AutolinkProvider {

  /**
   * Provides CamelCase node links.
   */
  function provideLinks($node) {
    $nodes = array();
    $available = $this->config->fetchArraySetting('camelcase_node_types')->getEnabled();
    if (in_array($node->type, $available)) {
      $types = $this->config->fetchArraySetting('destination_node_types')->getEnabled();
      if (!empty($types)) {
        $query = array();
        foreach ($types as $type) {
          $query[] = "type = '$type'";
        }
        $result = db_query('SELECT * FROM {node} WHERE ' . implode(' OR ', $query) . '');
        foreach ($result as $data) {
          $parts = explode(' ', preg_replace('/[^a-zA-Z0-9-\s]/', '', $data->title));
          $words = array_map('drupal_ucfirst', $parts);
          $nodes[] = array(
            'keyword' => implode('', $words),
            'path' => "node/{$data->nid}",
            'title' => $data->title,
          );
        }
      }
    }
    return $nodes;
  }

}

/**
 * Defines the CamelCase link type class.
 */
class AutolinkCamelCaseLink extends AutolinkLink {

  /**
   * Returns link attributes.
   */
  function getAttributes() {
    return array(
      'title' => $this->get('title'),
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }

}
