<?php

/**
 * @file
 * Defines the CamelCase plugin configuration form class.
 */

/**
 * Defines the CamelCase plugin configuration class.
 */
class AutolinkConfigFormCamelCase extends AutolinkConfigForm {

  /**
   * Defines the settings form.
   */
  protected function form(&$form_state, $settings) {
    $form['camelcase_links'] = array(
      '#type' => 'fieldset',
      '#title' => t('CamelCase links plugin'),
      '#collapsible' => TRUE,
    );
    $form['camelcase_links']['camelcase_node_types'] = array(
      '#type' => 'checkboxes',
      '#title' => t('Enable CamelCase links by content type'),
      '#options' =>  node_type_get_names(),
      '#default_value' => array_keys($this->getSettings('camelcase_node_types', node_type_get_names())),
      '#description' => t('Limit CamelCase linking by content type.'),
    );
    $form['camelcase_links']['destination_node_types'] = array(
      '#type' => 'checkboxes',
      '#title' => t('Destination content types'),
      '#options' =>  node_type_get_names(),
      '#default_value' => array_keys($this->getSettings('destination_node_types',  node_type_get_names())),
      '#description' => t('Select the node types to which may be linked to via CamelCase style links.'),
    );

    $form['attributes'] = array(
      '#type' => 'fieldset',
      '#title' => t('Link attributes'),
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
      '#description' => t('Default settings will be used to populate new link definition forms and when generating links in node content.'),
    );
    $form['attributes']['style'] = array(
      '#type' => 'textfield',
      '#title' => t('Style'),
      '#default_value' => $this->get('style', ''),
      '#description' => t('Although it is recommended that you use a stylesheet and class, inline styles may be used for additional link attributes.'),
    );
    $form['attributes']['class'] = array(
      '#type' => 'textfield',
      '#title' => t('Class'),
      '#default_value' => $this->get('class', ''),
      '#description' => t('New link definitions can automatically be assigned classes. To assign more than one class enter a space separated list.'),
    );
    $form['attributes']['target'] = array(
      '#type' => 'select',
      '#title' => t('Target'),
      '#options' => array(
        'none' => 'none',
        '_blank' => '_blank',
        '_parent' => '_parent',
        '_self' => '_self',
        '_top' => '_top',
      ),
      '#default_value' => $this->get('target', 'none'),
      '#description' => t('Specifies where to open internally linked documents.'),
    );
    return $form;
  }
}
