<?php

/**
 * @file
 * Defines link type classes for Autolink Brackets Plugin module.
 */

/**
 * Defines the bracket link type provider class.
 */
class AutolinkNodePatternProvider extends AutolinkProvider {

  /**
   * Provides bracket style links to Autolink.
   */
  function provideLinks($node) {
    $nodes = array();
    if ($this->config->get('node_pattern_links', 1) == 1) {
      $available = $this->config->fetchArraySetting('linkable_node_types')->getEnabled();
      if (in_array($node->type, $available)) {
        $types = $this->config->fetchArraySetting('node_types')->getEnabled();
        if (!empty($types)) {
          $query = array();
          foreach ($types as $type) {
            $query[] = "type = '$type'";
          }
          $pattern = $this->config->get('node_search', AUTOLINK_PATTERN_NODE);
          $result = db_query('SELECT * FROM {node} WHERE ' . implode(' OR ', $query) . '');
          foreach ($result as $data) {
            $node = node_load($data->nid);
            $nodes[$node->nid] = array(
              'keyword' => token_replace($pattern, array('node' => $node)),
              'path' => "node/{$node->nid}",
              'nid' => $node->nid,
              'node' => $node,
            );
          }
        }
      }
    }
    return $nodes;
  }

}

/**
 * Defines the term link class.
 */
class AutolinkPatternNodeLink extends AutolinkLink {

  /**
   * Returns link attributes.
   */
  function getAttributes() {
    $pattern = $this->config->get('node_title', '[title]');
    $node = $this->get('node');
    $title = !empty($node) && !empty($pattern) ? token_replace($pattern, array('node' => $node)) : '';

    return array(
      'title' => $title,
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }

  /**
   * Returns the replacement text.
   */
  function getText($match) {
    $node = $this->get('node');
    if ($node) {
      $pattern = $this->config->get('node_replace', AUTOLINK_PATTERN_REPLACE_NODE);
      return !empty($pattern) ? token_replace($pattern, array('node' => $node)) : $match; 
    }
    return $match;
  }
}

/**
 * Defines the bracket link type provider class.
 */
class AutolinkUserPatternProvider extends AutolinkProvider {

  /**
   * Provides bracket style links to Autolink.
   */
  function provideLinks($node) {
    $users = array();
    if ($this->config->get('user_pattern_links', 1) == 1) {
      $available = $this->config->fetchArraySetting('linkable_node_types')->getEnabled();
      if (in_array($node->type, $available)) {
        $roles = $this->config->fetchArraySetting('user_roles')->getEnabled();
        if (!empty($roles)) {
          $query = array();
          foreach ($roles as $rid) {
            $query[] = "r.rid = $rid";
          }
          $pattern = $this->config->get('user_search', AUTOLINK_PATTERN_USER);
          $result = db_query('SELECT u.* FROM {users} u LEFT JOIN {users_roles} r ON u.uid = r.uid WHERE u.uid <> 0 AND ' . implode(' OR ', $query));
          foreach ($result as $user) {
            $users[$user->uid] = array(
              'keyword' => token_replace($pattern, array('user' => $user)),
              'path' => "user/{$user->uid}",
              'uid' => $user->uid,
              'user' => $user,
            );
          }
        }
      }
    }
    return $users;
  }

}

/**
 * Defines the term link class.
 */
class AutolinkPatternUserLink extends AutolinkLink {

  /**
   * Returns link attributes.
   */
  function getAttributes() {
    $pattern = $this->config->get('user_title', '[user]');
    $user = $this->get('user');
    $title = !empty($user) && !empty($pattern) ? token_replace($pattern, array('user' => $user)) : '';

    return array(
      'title' => $title,
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }

  /**
   * Returns the replacement text.
   */
  function getText($match) {
    if ($user = $this->get('user')) {
      $pattern = $this->config->get('user_replace', AUTOLINK_PATTERN_REPLACE_USER);
      return !empty($pattern) ? token_replace($pattern, array('user' => $user)) : $match;
    }
    return $match;
  }
}

/**
 * Defines the bracket link type provider class.
 */
class AutolinkTermPatternProvider extends AutolinkProvider {

  /**
   * Provides bracket style links to Autolink.
   */
  function provideLinks($node) {
    $terms = array();
    if ($this->config->get('term_pattern_links', 1) == 1) {
      $available = $this->config->fetchArraySetting('linkable_node_types')->getEnabled();
      if (in_array($node->type, $available)) {
        $vocabularies = $this->config->fetchArraySetting('vocabularies')->getEnabled();
        if (!empty($vocabularies)) {
          $query = array();
          foreach ($vocabularies as $vid) {
            $query[] = "vid = '$vid'";
          }
          $pattern = $this->config->get('term_search', AUTOLINK_PATTERN_TERM);
          $result = db_query('SELECT * FROM {taxonomy_term_data} WHERE ' . implode(' OR ', $query));
          foreach ($result as $term) {
            $terms[$term->tid] = array(
              'keyword' => token_replace($pattern, array('term', $term)),
              'path' => "taxonomy/term/{$term->tid}",
              'tid' => $term->tid,
              'term' => $term,
            );
          }
        }
      }
    }
    return $terms;
  }

}

/**
 * Defines the term link class.
 */
class AutolinkPatternTermLink extends AutolinkLink {

  /**
   * Returns link attributes.
   */
  function getAttributes() {
    $pattern = $this->config->get('term_title', '[cat]');
    $term = $this->get('term');
    $title = !empty($term) && !empty($pattern) ? token_replace($pattern, array('term', $term)) : '';

    return array(
      'title' => $title,
      'style' => $this->config->get('style', ''),
      'class' => $this->config->get('class', ''),
      'target' => $this->config->get('target', 'none'),
    );
  }

  /**
   * Returns the replacement text.
   */
  function getText($match) {
    if ($this->get('term')) {
      $pattern = $this->config->get('term_replace', AUTOLINK_PATTERN_REPLACE_TERM);
      return !empty($pattern) ? token_replace($pattern, array('term', $term)) : $match;
    }
    return $match;
  }
}
