<?php

/**
 * @file
 * Defines the CamelCase plugin class for the Autolink CamelCase plugin.
 */

/**
 * Defines the CamelCase plugin class.
 */
class AutolinkCamelCasePlugin extends AutolinkPlugin {

  /**
   * Returns regular expression characters.
   */
  function getExpression(AutolinkLink $link) {
    return array('prepend' => '\b', 'append' => '\b');
  }

  /**
   * Returns link attributes.
   */
  function getAttributes(AutolinkLink $link) {
    if (method_exists($link, 'getAttributes')) {
      return $link->getAttributes();
    }
    return array();
  }

  /**
   * Returns the full node title.
   */
  function getText(AutolinkLink $link, $match) {
    return $link->get('title');
  }

  /**
   * Returns the case sensitivity of links.
   */
  function getCase(AutolinkLink $link) {
    return TRUE;
  }

}
