<?php

/**
 * @file
 * Plugin functions for Autolink Keyword Links plugin.
 */

/**
 * Prepares the processor object.
 */
function autolink_keyword_prepare(AutolinkProcessor $processor, $settings, $node, AutolinkCache $cache, $name) {
  if (in_array($node->type, $settings['node_types'])) {
    // Set item limits for limiting link generation from settings.
    $processor->total_limit = $settings['total_limit'];
    $processor->item_limit = $settings['link_limit'];
    $processor->case = $settings['case_sensitivity'];

    // Turn off item validation to prevent errors.
    $processor->validate_items = FALSE;

    // This expression prevents matching links that already exist.
    $processor->prefix = '/(?!(?:[^<]+>|[^>]+<\/a>))';
    $processor->prefix .= !empty($settings['word_boundaries']) ? '\b' : '';
    $processor->suffix = !empty($settings['word_boundaries']) ? '\b/' : '/';
  
    if ($items = $cache->get_items($node->type)) {
      $processor->add_items($items->data);
    }
    else {
      $links = array();
      $result = db_select('autolink_link', 'a')
        ->fields('a')
        ->condition('plugin', $name, '=')
        ->execute();
      while ($link = $result->fetchAssoc()) {
        // Links to nodes need to prevent that node from linking to itself.
        if ($link['plugin'] == 'autolink_keyword_node') {
          $args = explode('/', $link['path']);
          $link['nid'] = isset($args[1]) && is_numeric($args[1]) ? $args[1] : '';
        }
        $link['search'] = $link['keyword'];
        $links[] = $link;

        // We essentially create a new link array for each synonym.
        foreach (unserialize($link['synonyms']) as $keyword) {
          $synonym = $link;
          $synonym['search'] = $keyword;
          $links[] = $synonym;
        }
      }
      $processor->add_items($links);
      $cache->set_items($node->type, $links);
    }
  }
  // Halt the processing for this plugin if the node type is not enabled.
  else {
    $processor->skip();
  }
}

/**
 * Buils a link from a matched keyword.
 */
function autolink_keyword_link_replace($match, $settings, $item = array()) {
  if (menu_path_is_external($item['path'])) {
    $target = isset($settings['external_target']) ? $settings['external_target'] : '';
  }
  else {
    $target = isset($settings['internal_target']) ? $settings['internal_target'] : '';
  }

  $options = array(
    'query' => $item['query'],
    'absolute' => TRUE,
    'alias' => FALSE,
    'external' => $item['plugin'] == 'autolink_keyword_external',
    'attributes' => array(
      'title' => $item['search'],
      'style' => isset($settings['style']) ? $settings['style'] : '',
      'class' => isset($settings['class']) ? $settings['class'] : '',
      'target' => $target,
      'rel' => menu_path_is_external($item['path']) ? !empty($settings['external_relationship']) : '',
    ),
  );

  // Unset the empty attributes to avoid invalid markup and unnecessary attributes.
  if (!empty($options['attributes'])) {
    foreach ($options['attributes'] as $attribute => $value) {
      if (empty($value)) {
        unset($options['attributes'][$attribute]);
      }
    }
  }
  else {
    unset($options['attributes']);
  }

  // The target attribute causes _blank if 'none' is not unset.
  if ($options['attributes']['target'] == 'none') {
    unset($options['attributes']['target']);
  }

  return l($match, $item['path'], $options);
}
