# Automated Testing Kit

Automated Testing Kit (ATK) is a suite of tests and useful utilities for end-to-end
testing using Cypress and Playwright such as:

- basic login/logout via the UI
- registration and confirmation of the email via a fake SMTP service (ethereal.email)
- awareness of the QA Accounts module
- executing drush commands via aliases or to Pantheon via Terminus and ssh
- much more

ATK will work on the native OS (i.e. macOS/Linux), native OS + a container
(via DDEV/Lando/Docksal) or within a container. Consider using Docker
images to gain access to the pre-installed framework and browsers.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/automated_testing_kit).

Installation/configuration instructions plus the lists of functions and tests are in
the documentation
[here](https://performantlabs.com/automated-testing-kit/automated-testing-kit).

Join the Drupal [Slack workspace](https://www.drupal.org/join-slack) and
the #automated_testing_kit channel to ask questions.

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/automated_testing_kit).


## Table of contents

- Requirements
- Recommended modules
- Installation
- Configuration
- FAQ
- Maintainers


## Requirements

Install on the last version of Drupal 9.x or on Drupal 10+.

This module requires Cypress or Playwright to be installed plus the browsers you
will test on (all of which can be in containers). See those projects for installation
instructions.

The following module[s] are required:

- [Drush](https://www.drupal.org/project/webform)


## Recommended modules

Some tests require additional modules to be installed. If you don't want to use those
tests, comment them out and don't add the module[s] below to your composer.json file.
The documentaton lists the modules a test requires.

Here are the dependencies currently:

- [Webform](https://www.drupal.org/project/webform)
- [QA Accounts](https://www.drupal.org/project/qa_accounts)
- [Symfony Mailer](https://www.drupal.org/project/symfony_mailer)
- [XML Sitemap](https://www.drupal.org/project/xmlsitemap) or [Simple Sitemap](https://www.drupal.org/project/simple_sitemap)


## Installation

 * Install as you would normally install a contributed Drupal module. Visit
   https://www.drupal.org/node/1897420 for further information.
 * Installing the module without Composer is not recommended and is unsupported.
 * Definitely read the ATK documentation. You will want to move the tests to your project
   with the atk_setup script, set up the target URL and further customize the Kit for your
   Drupal installation.


## Configuration

Refer to the [documentation](https://performantlabs.com/automated-testing-kit/automated-testing-kit);
you will need to set the target URL and a few more items.

Automated Testing Kit has a configuration page located at
/admin/config/development/automated_testing_kit/edit (stub for now).


## FAQ

**Q: Which testing framework should I use, Cypress or Playwright or
something else?**

**A:** You'll find many videos and blog posts comparing tools
in the [Learning Resources area of the documentation](https://performantlabs.com/automated-testing-kit/learning-resources).


## Maintainers

- André Angelantoni - [aangel](https://www.drupal.org/u/aangel)
