/**
 * atk_register_login.cy.js
 *
 * Registration, login and forgotten password tests.
 *
 */

/** ESLint directives */
/* eslint-disable import/first */

/// <reference types='Cypress' />

// Set up ATK.
import * as atkCommands from '../../support/atk_commands'; // eslint-disable-line no-unused-vars
import * as atkUtilities from '../../support/atk_utilities';
import atkConfig from '../../../cypress.atk.config';

// Standard accounts that use user accounts created
// by QA Accounts. QA Accounts are created when the QA
// Accounts module is enabled.
import qaUserAccounts from '../../data/qaUsers.json';

describe('User registration and login tasks.', () => {
  //
  // Register the created user.
  //
  it('(ATK-CY-1000) Register with form.', { tags: ['@ATK-CY-1000', '@register-login', '@alters-db', '@smoke'] }, () => {
    const testId = 'ATK-CY-1000'; // eslint-disable-line no-unused-vars

    // Begin registration.
    const user = atkUtilities.createRandomUser();
    cy.visit(atkConfig.registerUrl).then(() => {
      cy.get('#edit-mail').type(user.userEmail);
      cy.get('#edit-name').type(user.userName);
      cy.get('#user-register-form > #edit-actions > #edit-submit').click();
    });

    // Should see the thank-you message.
    cy.contains('Thank you for applying for an account.');

    // Give the email some time to arrive.
    // eslint-disable-next-line cypress/no-unnecessary-waiting
    cy.wait(1000);
  });

  //
  // Log in with the login form into the authenticated account.
  //
  it('(ATK-CY-1010) Log in with form.', { tags: ['@ATK-CY-1010', '@register-login', '@smoke'] }, () => {
    const testId = 'ATK-CY-1010'; // eslint-disable-line no-unused-vars

    cy.logInViaForm(qaUserAccounts.authenticated);
  });

  //
  // Log in with a POST request into the authenticated account.
  // TODO: Not ready yet.
  //
  it.skip('(ATK-CY-1011) Log in with POST.', { tags: ['@ATK-CY-1011', '@register-login', '@smoke'] }, () => {
    const testId = 'ATK-CY-1011'; // eslint-disable-line no-unused-vars

    // cy.logInViaPost(qaUserAccounts.authenticated)
  });

  //
  // Log in with a ULI generated by Drupal.
  //
  it('(ATK-CY-1012) Log in via ULI.', { tags: ['@ATK-CY-1012', '@register-login', '@smoke'] }, () => {
    const testId = 'ATK-CY-1012'; // eslint-disable-line no-unused-vars

    cy.logInViaUli(1); // Log in as admin.
  });

  //
  // Create a user with Drush from a fixture and delete it.
  //
  it('(ATK-CY-1020) Create user with Drush, delete by email.', { tags: ['@ATK-CY-1020', '@register-login', '@smoke', 'alters-db'] }, () => {
    const testId = 'ATK-CY-1020'; // eslint-disable-line no-unused-vars

    const user = atkUtilities.createRandomUser();
    cy.createUserWithUserObject(user, []);
    cy.deleteUserWithEmail(user.userEmail, [], ['--delete-content']);
  });

  //
  // Create a user with Drush from a fixture and delete it by UID.
  //
  it('(ATK-CY-1021) Create user with Drush, delete by UID.', { tags: ['@ATK-CY-1021', '@register-login', '@smoke', 'alters-db'] }, () => {
    const testId = 'ATK-CY-1021'; // eslint-disable-line no-unused-vars

    const user = atkUtilities.createRandomUser();
    cy.createUserWithUserObject(user, []);
    cy.getUidWithEmail(user.userEmail).then((uid) => {
      cy.deleteUserWithUid(uid, [], ['--delete-content']);
    });
  });

  //
  // Validate reset password function.
  //
  it('(ATK-CY-1030) Reset password.', { tags: ['@ATK-CY-1030', '@register-login', '@smoke'] }, () => {
    const testId = 'ATK-CY-1030'; // eslint-disable-line no-unused-vars

    const user = atkUtilities.createRandomUser();

    cy.createUserWithUserObject(user, []);

    cy.visit(atkConfig.resetPasswordUrl).then(() => {
      cy.get('#edit-name').type(user.userName);
      cy.get('#user-pass > #edit-actions > #edit-submit').click();
    });

    // Check for tail end of reset message.
    cy.contains('an email will be sent with instructions to reset your password.');

    // Give the email some time to arrive.
    // eslint-disable-next-line cypress/no-unnecessary-waiting
    cy.wait(1000);

    cy.deleteUserWithEmail(user.userEmail, [], ['--delete-content']);
  });
});
