<?php

namespace Drupal\automatic_taxonomy_terms\Config;

use Drupal\Core\Config\ImmutableConfig;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\token\Token;
use InvalidArgumentException;

class EntityBundleConfiguration {
  use StringTranslationTrait;

  /** @var \Drupal\Core\Config\ImmutableConfig */
  private $config;
  /** @var \Drupal\token\Token */
  private $token;
  /** @var \Drupal\Core\Entity\EntityInterface */
  private $entity;
  /** @var string */
  private $label;
  /** @var int */
  private $parent;
  /** @var bool */
  private $sync;
  /** @var string */
  private $vocabularyName;

  /**
   * @param \Drupal\Core\Config\ImmutableConfig $config
   * @param \Drupal\token\Token $token
   * @param \Drupal\Core\Entity\EntityInterface $entity
   * @param array $properties
   */
  public function __construct(ImmutableConfig $config, Token $token, EntityInterface $entity, array $properties) {
    if (!isset($properties['label'])) {
      throw new InvalidArgumentException($this->t("Entity bundle configurations should at least have a \"label\" property."));
    }

    $this->config = $config;
    $this->token = $token;
    $this->entity = $entity;
    $this->label = $properties['label'];
    $this->parent = $properties['parent'] ?? 0;
    $this->sync = (bool) $properties['sync'];
    $this->vocabularyName = $properties['vocabulary'] ?? NULL;
  }

  /**
   * @return \Drupal\Core\Config\ImmutableConfig
   */
  public function config() {
    return $this->config;
  }

  /**
   * @return string
   */
  public function label() {
    $variables = [
      $this->entity->getEntityTypeId() => $this->entity
    ];
    return $this->token->replace($this->label, $variables, ['clear' => TRUE]);
  }

  /**
   * @return int
   */
  public function getTaxonomyTermParentId() {
    return $this->parent;
  }

  /**
   * @return bool
   */
  public function keepInSync() {
    return $this->sync;
  }

  /**
   * @return string
   */
  public function getVocabularyName() {
    return $this->vocabularyName;
  }

}