<?php

/**
 * Modified code checker.
 */
class ModifiedFiles implements ReadinessCheckerInterface {

  /**
   * {@inheritdoc}
   */
  public static function run() {
    return static::modifiedFilesCheck();
  }

  /**
   * Check if the site contains any modified code.
   *
   * @return array
   *   An array of translatable strings if any checks fail.
   */
  protected static function modifiedFilesCheck() {
    $messages = [];
    foreach (ModifiedFilesService::getModifiedFiles(static::getInfos()) as $file) {
      $messages[] = static::t('The hash for @file does not match its original. Updates that include that file will fail and require manual intervention.', ['@file' => $file]);
    }
    return $messages;
  }
  /**
   * Returns an array of info files information of available extensions.
   *
   * @return array
   *   An associative array of extension information arrays, keyed by extension
   *   name.
   */
  protected static function getInfos() {
    $extensions = drupal_system_listing('/^' . DRUPAL_PHP_FUNCTION_PATTERN . '\.info$/', 'modules', $key = 'name', $min_depth = 1);
    $infos = array_merge($extensions, drupal_system_listing('/^' . DRUPAL_PHP_FUNCTION_PATTERN . '\.info$/', 'themes', $key = 'name', $min_depth = 1));
    $system = $infos['system'];
    $infos = array_filter($infos, function($info) {
      return substr($info->uri, 0, 7) !== "modules" && substr($info->uri, 0, 6) !== "themes";
    });
    $infos['drupal']  = $system;
    return $infos;
  }

}
