<?php

/**
 * @file
 * Administration functions for Automatic Updates module.
 */

/**
 * Form callback for administrator interface.
 */
function automatic_updates_admin_form() {
  $form['description'] = [
    '#markup' => '<p>' . t('Public service announcements are compared against the entire code for the site, not just installed extensions.') . '</p>',
  ];
  $form['automatic_updates_enable_psa'] = [
    '#type' => 'checkbox',
    '#title' => t('Show Public service announcements on administrative pages.'),
    '#default_value' => variable_get('automatic_updates_enable_psa', TRUE),
  ];
  $form['automatic_updates_notify'] = [
    '#type' => 'checkbox',
    '#title' => t('Send email notifications for Public service announcements.'),
    '#default_value' => variable_get('automatic_updates_notify', TRUE),
    '#description' => t('The email addresses listed in <a href="@update_manager">update manager settings</a> will be notified.', ['@update_manager' => url('admin/reports/updates/settings')]),
  ];
  $last_check_timestamp = ReadinessCheckerManager::timestamp();
  $form['automatic_updates_enable_readiness_checks'] = [
    '#type' => 'checkbox',
    '#title' => t('Check the readiness of automatically updating the site.'),
    '#default_value' => variable_get('automatic_updates_enable_readiness_checks', TRUE),
  ];
  if (ReadinessCheckerManager::isEnabled()) {
    $form['automatic_updates_enable_readiness_checks']['#description'] = t('Readiness checks were last run @time ago. Manually <a href="@link">run the readiness checks</a>.', [
      '@time' => format_interval(REQUEST_TIME - $last_check_timestamp),
      '@link' => url('admin/config/system/automatic_updates/readiness'),
    ]);
  }
  $form['automatic_updates_ignored_paths'] = [
    '#type' => 'textarea',
    '#title' => t('Paths to ignore for readiness checks'),
    '#description' => t('Paths relative to %drupal_root. One path per line.', ['%drupal_root' => DRUPAL_ROOT]),
    '#default_value' => variable_get('automatic_updates_ignored_paths', "sites/all/modules/custom/*\nsites/all/themes/custom/*"),
    '#states' => [
      'visible' => [
        ':input[name="automatic_updates_enable_readiness_checks"]' => ['checked' => TRUE],
      ],
    ],
  ];
  return system_settings_form($form);
}

/**
 * Page callback to run all checkers.
 */
function automatic_updates_run_checks() {
  $messages = [];
  foreach (ReadinessCheckerManager::getCategories() as $category) {
    $messages = array_merge(ReadinessCheckerManager::run($category), $messages);
  }
  if (empty($messages)) {
    drupal_set_message(t('No issues found. Your site is completely ready for <a href="@readiness_checks">automatic updates</a>.', ['@readiness_checks' => 'https://www.drupal.org/docs/8/update/automatic-updates#readiness-checks']), 'status', FALSE);
  }
  drupal_goto('admin/config/system/automatic_updates');
}
