<?php

/**
 * Wrapper function to make the Volacci API
 * @return output
 * @todo
 */
function volacci_automatr_request($class, $method, $params) {
  $ch = curl_init('https://apps.net-results.com/api/v2/rpc/server.php?Controller=' . $class);
  $automatr_login = variable_get('automatr_login', array());
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
  curl_setopt($ch, CURLOPT_USERPWD, $automatr_login['username'] . '@' . $automatr_login['domain'] . ':' . $automatr_login['password']);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(array(
        'id' => uniqid(),
        'method' => $method,
        'jsonrpc' => '2.0',
        'params' => $params,
          )
      )
  );
  curl_setopt($ch, CURLOPT_POST, TRUE);
  $response = curl_exec($ch);
  $response = json_decode($response);
  if (isset($response->error)) {
    throw new Exception('Unable to access the server at this time');
  }
  return $response;
}

function volacci_automatr_get_alerts() {
  $class = 'Alert';
  $method = 'getMultiple';
  $params = array(
    'offset' => '0',
    'limit' => '100',
    'order_by' => 'alert_name',
    'order_dir' => 'ASC',
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/*
 * Function to get the list of custom contact fields
 */

function volacci_extra_get_custom_contact_fields() {
  $class = 'CustomAttribute';
  $method = 'getMultiple';
  $params = array(
    'offset' => '0',
    'limit' => '10',
    'order_by' => 'custom_attribute',
    'order_dir' => 'DESC',
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

function volacci_automatr_get_one_contact($contct_id) {
  $params = array(
    'contact_id' => $contct_id
  );
  return volacci_automatr_request('Contact', 'getOne', $params);
}

function volacci_automatr_get_contact_by_email($email) {
  $class = 'Contact';
  $method = 'getContactIdByEmailAddress';
  $params = array(
    'email_address' => $email
  );
  return volacci_automatr_request($class, $method, $params);
}

/*
 * Function to get the list of custom contact field labels
 */

function volacci_extra_get_custom_contact_field_labels() {
  $response = volacci_extra_get_custom_contact_fields();
  $field_labels = array();
  foreach ($response->result->results as $result) {
    $field_labels[$result->custom_attribute] = $result->custom_attribute;
  }
  return $field_labels;
}

/*
 * Function to get the list of segments available
 */

function volacci_extra_get_segments() {
  $class = 'ContactSegment';
  $method = 'getMultiple';
  $params = array(
    'offset' => '0',
    'limit' => '10',
    'order_by' => 'contact_segment_name',
    'order_dir' => 'DESC',
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/*
 * Function to get the list of Email lists available
 */

function volacci_extra_get_lists() {
  $class = 'EmailList';
  $method = 'getMultiple';
  $params = array(
    'offset' => '0',
    'limit' => '10',
    'order_by' => 'email_list_name',
    'order_dir' => 'ASC',
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/*
 * Function to get key value pair from the results array
 */

function get_key_value_from_results($response, $key_attribute, $value_attribute) {
  $results_array = array();
  foreach ($response->result->results as $result) {
    $result = (array) $result;
    $results_array[$result[$key_attribute]] = $result[$value_attribute];
  }
  return $results_array;
}

/**
 * Returns the folder list of volacci
 * @return type
 */
function get_folder_list() {
  $dash = '-';
  $class = 'FolderEmailList';
  $method = 'getFolderTree';
  $params = array();
  $folders = volacci_automatr_request($class, $method, $params);
  if (!empty($folders->result)) {
    $folder_list = get_branch_folders($folders->result, $dash);
  }
  return iterator_to_array(new RecursiveIteratorIterator(new RecursiveArrayIterator($folder_list)), TRUE);
}

/**
 * Recursive function to get the sub-folders
 * @param type $folders
 * @param string $dash
 * @return type
 */
function get_branch_folders($folders, $dash) {
  foreach ($folders as $folder) {
    if (!$folder->is_root) {
      $folder_name = $dash . $folder->folder_name;
    }
    else {
      $folder_name = $folder->folder_name;
    }
    $folder_list[$folder->folder_id] = $folder_name;
    if (isset($folder->branches)) {
      $dash .= '-';
      $folder_list[] = get_branch_folders($folder->branches, $dash);
    }
  }
  return $folder_list;
}

function volacci_extra_get_lead_overlay_id() {
  $class = 'LeadScoreOverlay';
  $method = 'getMultiple';
  $params = array(
    'offset' => '0',
    'limit' => '10',
    'order_by' => 'contact_score_overlay_name',
    'order_dir' => 'DESC',
  );
  $response = volacci_automatr_request($class, $method, $params);
  //return $lead_overlay_ids;
}

function volacci_extra_get_reports_list() {
  $class = 'Report';
  $method = 'getMultiple';
  $params = array(
    'offset' => '0',
    'limit' => '10',
    'order_by' => 'report_name',
    'order_dir' => 'ASC',
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/**
 * Helper function to check wether the volacci is configured.
 * @return boolean
 * @throws Exception
 */
function check_volacci_connection() {
  $automatr_login = variable_get('automatr_login', array());
  if (empty($automatr_login)) {
    throw new Exception(t('Volacci details are not entered, please enter in the configuration page.'));
  }
  return TRUE;
}