<?php

module_load_include('inc', 'volacci_automatr_extra', 'helper');
/*
 * Form for Alert creation
 */

function volacci_extra_create_alert_form() {
  $form = array();
  try {
    check_volacci_connection();
    drupal_set_title(t('Create Alert'));
    $response = volacci_extra_get_segments();
    $options = get_key_value_from_results($response, 'contact_segment_id', 'contact_segment_name');
    $items = array(
      array(
        'data' => t('Alerts may be sent to multiple recipients simultaneously.')
      ),
      array(
        'data' => t('Alert recipients are not required to have a Automatr account.')
      ),
      array(
        'data' => t('You may create an unlimited number of Alerts.')
      ),
      array(
        'data' => t('The number of Alerts you create has no impact on your subscription fee.')
      )
    );
    $form['alert_title'] = array(
      '#markup' => "<div class='top-header'>" . l(t("Automatr Alerts"), "http://support.volacciapp.com/index.php/Alerts", array('attributes' => array('external' => TRUE, 'target' => 'single_window')))
      . " are driven by " . l(t('Segments'), 'http://support.volacciapp.com/index.php/Segments', array('attributes' => array('external' => TRUE, 'target' => 'single_window')))
      . t(". An Alert is triggered when a Contact qualifies for the Segment you've chosen.") . '</div>'
    );
    $form['alert_list'] = array(
      '#type' => 'item',
      '#markup' => theme('item_list', array('items' => $items))
    );
    $form['alert_segment'] = array(
      '#type' => 'select',
      '#title' => t('Alert Segment'),
      '#options' => $options,
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['alert_name'] = array(
      '#type' => 'textfield',
      '#title' => t('Alert Name'),
      '#required' => TRUE,
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['alert_description'] = array(
      '#type' => 'textarea',
      '#title' => t('Alert Description'),
      '#required' => TRUE,
      '#value' => 'Alert Description',
    );
    $options = array(
      2 => t('Enhanced'),
      1 => t('Immediate'),
    );
    $form['alert_type'] = array(
      '#type' => 'select',
      '#title' => t('Alert Type'),
      '#options' => $options,
      '#default_value' => 2,
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['alert_recipients'] = array(
      '#type' => 'textarea',
      '#title' => t('Send this Alert to'),
      '#description' => t('(Separate Multiple addresses with a comma)'),
      '#required' => TRUE,
      '#rows' => 3,
    );
    $form['alert_submit'] = array(
      '#type' => 'submit',
      '#value' => t('Create Alert'),
    );
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $form;
}

function volacci_extra_create_alert_form_validate($form, &$form_state) {
  $report_recipients = check_plain($form_state['values']['alert_recipients']);
  $pattern = '/^[\W]*([\w+\-.%]+@[\w\-.]+\.[A-Za-z]{2,4}[\W]*,{1}[\W]*)*([\w+\-.%]+@[\w\-.]+\.[A-Za-z]{2,4})[\W]*$/';
  if (!preg_match($pattern, $report_recipients)) {
    form_set_error('report_recipients', 'Invalid E-Mail Address.');
  }
}

/*
 * Alert creation using Volacci API
 * We are still waiting for a few inputs from the NR team
 */

function volacci_extra_create_alert_form_submit($form, &$form_state) {
  try {
    $class = 'Alert';
    $method = 'setOne';
    $values = $form_state['values'];
    $alert = array(
      'alert_name' => check_plain($values['alert_name']),
      'alert_recipients' => 'gokul@azrisolutions.com',
      'alert_active' => '0',
      'contact_segment_id' => check_plain($values['alert_segment']),
      'alert_description' => check_plain($values['alert_description']),
      'rbac_role_id' => NULL,
      'alert_detail_type_id' => check_plain($values['alert_type']),
    );
    $params = array(
      'alert' => $alert,
    );
    $response = volacci_automatr_request($class, $method, $params);
    drupal_set_message(t('The Alert has been created successfully.'));
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
}

function volacci_automatr_extra_alerts_list() {
  $alert_list = "<div class='top-header'>" . l(t("Automatr Alerts"), "http://support.volacciapp.com/index.php/Alerts", array('attributes' => array('external' => TRUE, 'target' => 'single_window')))
      . " are driven by " . l(t('Segments'), 'http://support.volacciapp.com/index.php/Segments', array('attributes' => array('external' => TRUE, 'target' => 'single_window')))
      . t(". An Alert is triggered when a Contact qualifies for the Segment you've chosen.") . '</div>';
  try {
    check_volacci_connection();
    drupal_set_title(t('List Alerts'));
    $response = volacci_automatr_get_alerts();
    $alerts = $response->result->results;
    $header = array(t('Alert'), t('Segment'), t('Type'), t('Recipients'));
    foreach ($alerts as $alert) {
      $alert_name = l($alert->alert_name, 'https://a.volacciapp.com/data/public/Alert/setup?intAlertId=' . $alert->alert_id, array('attributes' => array('target' => 'single_window')));
      $alert_segment = $alert->contact_segment_name;
      $alert_type = $alert->alert_detail_type;
      $alert_recipients = $alert->alert_recipients;
      $rows[] = array($alert_name, $alert_segment, $alert_type, $alert_recipients);
    }
    if (!empty($rows)) {
      $alert_table['header'] = $header;
      $alert_table['rows'] = $rows;
      $alert_table['attributes'] = array('class' => array('alert-list', 'va-table'));
      $alert_list .= theme('table', $alert_table);
    }
    else {
      $alert_list .= t('No Alerts.');
    }
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $alert_list;
}