<?php

module_load_include('inc', 'volacci_automatr_extra', 'helper');

/**
 * Implements hook_form;
 * Creating Email List
 * @param type $form
 * @param type $form_state
 * @return type
 */
function volacci_extra_email_list_form($form, &$form_state) {
  $form = array();
  try {
    check_volacci_connection();
    drupal_set_title(t('Create List'));
    $items_list = array(
      array(
        'data' => t('You may create an unlimited number of Lists.')
      ),
      array(
        'data' => t('Each List may have an unlimited number of ')
        . l(t('Contacts'), 'http://support.volacciapp.com/index.php/Contacts', array('attributes' => array('external' => TRUE, 'target' => '_blank')))
        . t(' associated with it.')
      ),
      array(
        'data' => t('Each Contact may be a member of an unlimited number of Lists.')
      ),
      array(
        'data' => t('The number of Lists you create has no impact on your subscription fee.')
      ),
      array(
        'data' => t('You can easily use Lists to perform ')
        . l(t('A/B Split Testing'), 'http://support.volacciapp.com/index.php/A/B_Testing', array('attributes' => array('external' => TRUE, 'target' => '_blank')))
      )
    );
    $form['list_title'] = array(
      '#markup' => "<div class='top-header'>" . l(t('More about Lists.'), 'http://support.volacciapp.com/index.php/Lists', array('attributes' => array('external' => TRUE, 'target' => 'automatr-support'))) . '</div>'
    );
    $form['list_help'] = array(
      '#type' => 'item',
      '#markup' => theme('item_list', array('items' => $items_list))
    );
    $form['list_name'] = array(
      '#title' => t('List Name'),
      '#type' => 'textfield',
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['store_in_folder'] = array(
      '#type' => 'select',
      '#title' => 'Store in folder',
      '#options' => get_folder_list(),
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['submit'] = array(
      '#value' => t('Save'),
      '#type' => 'submit',
    );
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $form;
}

/**
 * Implements hook_form_submit;
 * @param type $form
 * @param type $form_state
 */
function volacci_extra_email_list_form_submit($form, &$form_state) {
  try {
    $class = 'EmailList';
    $method = 'setOne';
    $values = $form_state['values'];
    $email_list = array(
      'email_list_name' => check_plain($values['list_name']),
      'rbac_role_id' => NULL,
      'email_list_folder_id' => $values['store_in_folder'],
    );
    $params = array(
      'email_list' => $email_list,
    );
    $response = volacci_automatr_request($class, $method, $params);
    drupal_set_message(t('The List has been created successfully.'));
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
}

function volacci_automatr_extra_email_list() {
  $email_list = "<div class='top-header'>" . t('Automatr Lists are like "tags" that are used on blogs and other Web 2.0 applications. 
                    Because Automatr Segments allow you to filter Contacts based on List membership, 
                    you can do some very powerful things with Lists and Segments.')
      . l(t('More about Lists.'), 'http://support.volacciapp.com/index.php/Lists', array('attributes' => array('external' => TRUE, 'target' => 'automatr-support'))) . '</div>';
  try {
    check_volacci_connection();
    drupal_set_title(t('Email Lists'));
    $response = volacci_extra_get_lists();
    $email_lists = $response->result->results;
    $header = array(t('List'), t('Size'), t('Mailable Size'), t('Last Modified'));
    foreach ($email_lists as $email) {
      $email_list_name = l($email->email_list_name, 'https://a.volacciapp.com/data/public/Contact/list?Filter[0][p]=ListMembership&Filter[0][op]=1&Filter[0][c]=' . $email->email_list_id . '&Filter[0][a]=1&Filter[0][overwrite]=1', array('attributes' => array('target' => 'single_window')));
      $member_count = $email->member_count;
      $member_mailable_count = $email->member_mailable_count;
      $last_updated = $email->last_updated;
      $rows[] = array($email_list_name, $member_count, $member_mailable_count, $last_updated);
    }
    if (!empty($rows)) {
      $email_list_table['header'] = $header;
      $email_list_table['rows'] = $rows;
      $email_list_table['attributes'] = array('class' => array('email-lists', 'va-table'));
      $email_list .= theme('table', $email_list_table);
    }
    else {
      $email_list .= t('No Lists.');
    }
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $email_list;
}
