<?php

module_load_include('inc', 'volacci_automatr_extra', 'helper');

/**
 * Implements hook_form;
 * Create Reports
 * @return type
 */
function volacci_extra_create_report_form() {
  $form = array();
  try {
    check_volacci_connection();
    drupal_set_title(t('Create Report'));
    $output = t('Report Form');
    $response = volacci_extra_get_segments();
    $options = get_key_value_from_results($response, 'contact_segment_id', 'contact_segment_name');
    $type_options = array(t('My Visitors'), t('Traffic Sources'), t('Searches'), t('Pages Viewed'), t('Contacts'), t('The Rundown'));
    $type_options_description = array(
      t('Contacts who qualified for the selected Segment and visited your website during the reporting period.'),
      t('Traffic Sources that brought visitors to your website during the reporting period.'),
      t('Search Phrases that brought visitors to your website during the reporting period.'),
      t('Pages Viewed by Contacts who qualified for the selected Segment during the reporting period.'),
      t('All Contacts who qualified for the selected Segment during the reporting period. (Limited to 15000 Contacts.)'),
      t('Top 10 Visitors, Traffic Sources, Searches, and Pages Viewed for the selected Segment during the reporting period.')
    );
    $sort_by_options = array(t('Lead Score'), t('Number of Pages Viewed'), t('Company Name'), t('Date'));
    $report_frequency_options = array(t('Daily'), t('Weekly'), t('Monthly'), t('Immediate'));
    $report_frequency_options_descriptions = array(
      t('Sent after midnight to report on the previous day.'),
      t('Sent on Monday mornings to report on Monday through Sunday of the previous week.'),
      t('Sent on the first of the month to report on the previous month.'),
      t('Reports: Sent one-time as soon as possible.')
    );
    $items_list = array(
      array(
        'data' => t('Immediate Reports are sent one-time as soon as possible.')
      ),
      array(
        'data' => t('Daily Reports are sent after midnight and represent the previous day.')
      ),
      array(
        'data' => t('Weekly Reports are sent on Monday mornings and represent Monday through Sunday of the previous week.')
      ),
      array(
        'data' => t('Monthly Reports are sent on the first day of each month and represent all data from the previous month.')
      ),
      array(
        'data' => t('Reports are created and sent within the context of a Segment.')
      )
    );

    $form['report-title'] = array(
      '#markup' => "<div class='top-header'>" . t('Automatr emails reports on a daily, weekly, or monthly basis. Reports are sent as attachments in Microsoft Excel format. ')
      . l(t('More about Alerts.'), "http://support.volacciapp.com/index.php/Reports", array('attribtes' => array('target' => "automatr-support"))) . '</div>'
    );
    $form['report_segment'] = array(
      '#type' => 'select',
      '#title' => t('Segment'),
      '#options' => $options,
      '#description' => t('Reports are always based on a Segment. Segment settings also apply to the Report sent, including time zone. ') . l(t('More about Segments.'), "http://support.volacciapp.com/index.php/Segments", array('attribtes' => array('target' => "automatr-support"))),
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['report_type_id'] = array(
      '#type' => 'select',
      '#options' => $type_options,
      '#title' => t('Type'),
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    foreach ($form['report_type_id']['#options'] as $key => $label) {
      $form['report_type_id_' . $key] = array(
        '#type' => 'item',
        '#markup' => $type_options_description[$key],
        '#states' => array(
          'visible' => array(
            ':input[name="report_type_id"]' => array('value' => $key),
          ),
        ),
        '#prefix' => "<div class = 'report-description'>",
        '#suffix' => "</div>"
      );
    }
    $form['report_number_results'] = array(
      '#type' => 'select',
      '#title' => t('Number Of Results'),
      // The options here are integers, but since all the action here happens
      // using the DOM on the client, we will have to use strings to work with
      // them.
      '#options' => array(10 => 10, 20 => 20, 30 => 30, 40 => 40, 50 => 50),
      '#states' => array(
        'visible' => array(
          ':input[name="report_type_id"]' => array(array('value' => 1), array('value' => 2), array('value' => 3), array('value' => 4)),
        ),
      ),
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['report_sort_by_type_id'] = array(
      '#type' => 'select',
      '#options' => $sort_by_options,
      '#title' => t('Sort By'),
      '#states' => array(
        'visible' => array(
          ':input[name="report_type_id"]' => array('value' => 0),
        ),
      ),
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['report_detail_type_id'] = array(
      '#type' => 'select',
      '#options' => array(
        t('Summary'), t('Detail')
      ),
      '#states' => array(
        'visible' => array(
          ':input[name="report_type_id"]' => array('value' => 3),
        ),
      ),
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['report_aggregation_type_id'] = array(
      '#type' => 'select',
      '#options' => array(
        t('By Page'), t('By Contact')
      ),
      '#states' => array(
        'visible' => array(
          ':input[name="report_type_id"]' => array('value' => 3),
        ),
      ),
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['report_page_type'] = array(
      '#type' => 'textfield',
      '#title' => t('Filter by pages containing'),
      '#states' => array(
        'visible' => array(
          ':input[name="report_type_id"]' => array('value' => 3),
        ),
      ),
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['report_name'] = array(
      '#type' => 'textfield',
      '#title' => t('Report Name'),
      '#required' => TRUE,
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['report_recipients'] = array(
      '#type' => 'textarea',
      '#title' => t('Send Report To'),
      '#description' => t('(Separate Multiple addresses with a comma)'),
      '#required' => TRUE
    );
    $form['report_frequency'] = array(
      '#type' => 'select',
      '#title' => t('Report Frequency'),
      '#options' => $report_frequency_options,
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    foreach ($form['report_frequency']['#options'] as $key => $label) {
      $form['report_frequency_' . $key] = array(
        '#type' => 'item',
        '#markup' => $report_frequency_options_descriptions[$key],
        '#states' => array(
          'visible' => array(
            ':input[name="report_frequency"]' => array('value' => $key),
          ),
        ),
        '#prefix' => "<div class = 'report-description'>",
        '#suffix' => "</div>"
      );
    }
    $form['submit'] = array(
      '#type' => 'submit',
      '#value' => t('Create Report'),
    );
    //$form['#theme'] = 'volacci_extra_create_report_form';
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $form;
}

/**
 * Implements hook_form_validate;
 * @param type $form
 * @param type $form_state
 */
function volacci_extra_create_report_form_validate($form, &$form_state) {
  $report_recipients = check_plain($form_state['values']['report_recipients']);
  $pattern = '/^[\W]*([\w+\-.%]+@[\w\-.]+\.[A-Za-z]{2,4}[\W]*,{1}[\W]*)*([\w+\-.%]+@[\w\-.]+\.[A-Za-z]{2,4})[\W]*$/';
  if (!preg_match($pattern, $report_recipients)) {
    form_set_error('report_recipients', 'Invalid E-Mail Address.');
  }
}

/**
 * Implements hook_form_submit;
 * @param type $form
 * @param type $form_state
 */
function volacci_extra_create_report_form_submit($form, &$form_state) {
  try {
    $class = 'Report';
    $method = 'setOne';
    $report_type_id = $form_state['values']['report_type_id'];
    $report['report_name'] = check_plain($form_state['values']['report_name']);
    $report['report_frequency_type_id'] = $form_state['values']['report_frequency'];
    $report['report_recipients'] = check_plain($form_state['values']['report_recipients']);
    $report['rbac_role_id'] = NULL;
    $report['contact_segment_id'] = $form_state['values']['report_segment'];
    $report['report_type_id'] = $report_type_id;
    $number_results = $form_state['values']['report_number_results'];
    $report['report_number_results_my_visitors'] = 10;
    $report['report_number_results_traffic_sources'] = 10;
    $report['report_number_results_searches'] = 10;
    $report['report_number_results_pages_viewed'] = 10;
    switch ($report_type_id) {
      case 1:
        $report['report_number_results_my_visitors'] = $number_results;
        $report['report_sort_by_type_id'] = $form_state['values']['report_sort_by_type_id'];
        break;
      case 2:
        $report['report_number_results_traffic_sources'] = $number_results;
        break;
      case 3:
        $report['report_number_results_searches'] = $number_results;
        break;
      case 4:
        $report['report_number_results_pages_viewed'] = $number_results;
        $report['report_detail_type_id'] = $form_state['values']['report_detail_type_id'];
        $report['report_aggregation_type_id'] = $form_state['values']['report_aggregation_type_id'];
        $report['report_page_type'] = check_plain($form_state['values']['report_page_type']);
        break;
    }
    $params = array('report' => $report);
    $response = volacci_automatr_request($class, $method, $params);
    drupal_set_message(t('The Report has been created successfully.'));
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
}

function volacci_automatr_extra_reports_list() {
  $report_list = "<div class='top-header'>" .
      t('This is a list of existing reports. Click the report name to edit it. ') . l(t('More about Reports.'), "http://support.volacciapp.com/index.php/Reports", array('attribtes' => array('target' => "automatr-support"))) . '</div>';
  try {
    check_volacci_connection();
    drupal_set_title(t('Reports List'));
    $response = volacci_extra_get_reports_list();
    $reports = $response->result->results;
    $header = array(t('Report'), t('Segment'), t('Type'), t('Recipients'), t('Frequency'));
    foreach ($reports as $report) {
      $report_name = l($report->report_name, 'https://a.volacciapp.com/data/public/Report/setup?intReportId=' . $report->report_id, array('attributes' => array('target' => 'single_window')));
      $contact_segment_name = $report->contact_segment_name;
      $report_type = $report->report_type;
      $report_recipients = $report->report_recipients;
      $report_frequency_type = $report->report_frequency_type;
      $rows[] = array($report_name, $contact_segment_name, $report_type, $report_recipients, $report_frequency_type);
    }
    if (!empty($rows)) {
      $report_table['header'] = $header;
      $report_table['rows'] = $rows;
      $report_table['attributes'] = array('class' => array('reports-list', 'va-table'));
      $report_list .= theme('table', $report_table);
    }
    else {
      $report_list .= t('No Alerts.');
    }
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $report_list;
}