<?php

/**
 * @file
 * The file containing the helper functions for most of the functionality that is provided
 * by the API
 * 
 */

define('LIMIT_VALUE', 50);
define('DEFAULT_RESULTS_PER_PAGE', 50);
/**
 * Wrapper function to make the Volacci API
 * @return output
 * @todo
 */
function volacci_automatr_request($class, $method, $params) {
  $ch = curl_init('https://apps.net-results.com/api/v2/rpc/server.php?Controller=' . $class);
  $automatr_login = variable_get('automatr_login', array());
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
  curl_setopt($ch, CURLOPT_USERPWD, $automatr_login['username'] . ':' . $automatr_login['password']);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(array(
        'id' => uniqid(),
        'method' => $method,
        'jsonrpc' => '2.0',
        'params' => $params,
          )
      )
  );
  curl_setopt($ch, CURLOPT_POST, TRUE);
  $response = curl_exec($ch);
  $response = json_decode($response);
  if (isset($response->error)) {
    watchdog('Automatr', t('Class : ') . $class . ', ' . t('Method : ') . $method . ', ' . t('Error message : ') . $response->error->message, array($response->error->data), WATCHDOG_ERROR);
    throw new Exception($response->error->message);
  }
  return $response;
}

/*
 * Function to get all Alerts
 */

function volacci_extra_get_all_alerts() {
  if ($cached = cache_get('volacci_extra_get_all_alerts', 'cache'))  {
    $full_alerts_key_values = $cached->data;
  }
  if (empty($full_alerts_key_values)) {
    $full_alerts = array();
    $full_alerts_key_values = array();
    try {
      check_volacci_connection();
      $response = volacci_automatr_get_alerts();
      $total_records = $response->result->totalRecords;
      if ($total_records > 0) {      
        // Define items per call
        $num_per_page = DEFAULT_RESULTS_PER_PAGE;
        // Loop through all alerts
        for ($i = 0; $i < ceil($total_records/$num_per_page); $i++) {
          $offset = ($i) * $num_per_page;
          $response = volacci_automatr_get_alerts($offset, $num_per_page);
          $full_alerts = array_merge($full_alerts, $response->result->results);
        }
        foreach ($full_alerts as $values) {
          $full_alerts_key_values[$values->alert_id] = $values->alert_name;
        }
      }
      else {
        drupal_set_message(t("List is empty ! Contact Administrator.."));
      }
    } catch (Exception $e) {
        drupal_set_message($e->getMessage(), 'error');
    }
  }
  cache_set('volacci_extra_get_all_alerts', $full_alerts_key_values, 'cache', CACHE_TEMPORARY);
  return $full_alerts_key_values;
}


function volacci_automatr_get_alerts($offset = '0', $limit_value = LIMIT_VALUE, $order_by = 'alert_name', $order_dir = 'ASC', $extra_params = array()) {
  $class = 'Alert';
  $method = 'getMultiple';
  $params = array(
    'offset' => $offset,
    'limit' => $limit_value,
    'order_by' => $order_by,
    'order_dir' => $order_dir,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}






/*
 * Function to get the list of custom contact fields
 */

function volacci_extra_get_custom_contact_fields($offset = '0', $limit_value = LIMIT_VALUE, $order_by = 'custom_attribute', $order_dir = 'ASC', $extra_params = array()) {
  $class = 'CustomAttribute';
  $method = 'getMultiple';
  $params = array(
    'offset' => $offset,
    'limit' => $limit_value,
    'order_by' => $order_by,
    'order_dir' => $order_dir,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/*
 * Function to get all Custom Fields
 */

function volacci_extra_get_all_custom_contact_fields() {
  if ($cached = cache_get('volacci_extra_get_all_custom_contact_fields', 'cache'))  {
    $full_contact_fields_key_values = $cached->data;
  }
  if (empty($full_contact_fields_key_values)) {
    $full_contact_fields = array();
    $full_contact_fields_key_values = array();
    try {
      check_volacci_connection();
      $response = volacci_extra_get_custom_contact_fields();
      $total_records = $response->result->totalRecords;
      if ($total_records > 0) {      
        // Define items per call
        $num_per_page = DEFAULT_RESULTS_PER_PAGE;
        // Loop through all contact fields
        for ($i = 0; $i < ceil($total_records/$num_per_page); $i++) {
          $offset = ($i) * $num_per_page;
          $response = volacci_extra_get_custom_contact_fields($offset, $num_per_page);
          $full_contact_fields = array_merge($full_contact_fields, $response->result->results);
        }
        foreach ($full_contact_fields as $values) {
          $full_contact_fields_key_values[$values->custom_attribute_id] = $values->custom_attribute;
        }
      }
      else {
        drupal_set_message(t("List is empty ! Contact Administrator.."));
      }
    } catch (Exception $e) {
        drupal_set_message($e->getMessage(), 'error');
    }
  }
  cache_set('volacci_extra_get_all_custom_contact_fields', $full_contact_fields_key_values, 'cache', CACHE_TEMPORARY);
  return $full_contact_fields_key_values;
}


function volacci_automatr_get_one_contact($contct_id) {
  $params = array(
    'contact_id' => $contct_id
  );
  $response = volacci_automatr_request('Contact', 'getOne', $params);
  return $response;
}

function volacci_automatr_get_contact_by_email($email) {
  $class = 'Contact';
  $method = 'getContactIdByEmailAddress';
  $params = array(
    'email_address' => $email
  );
  return volacci_automatr_request($class, $method, $params);
}


function volacci_automatr_get_contact_activity($contact_id, $offset = '0', $limit_value = LIMIT_VALUE, $order_by = 'contact_activity_history_date', $order_dir = 'DESC', $extra_params = array()) {
  $class = 'ContactActivityHistory';
  $method = 'getContactActivity';
  if(!isset($params['activity_type'])){
    $params['activity_type'] = '';
  }
  $filters = array('contact_activity_history_type_id' => $extra_params['activity_type'] );
  $params = array(
    'contact_id' => $contact_id,
    'offset' => $offset,
    'limit' =>  $limit_value,
    'order_by' => $order_by,
    'order_dir' => $order_dir,
    'filters' => $filters,
  );
  return volacci_automatr_request($class, $method, $params);
}

function volacci_automatr_get_contact_activity_types() {
  $class = 'ContactActivityHistory';
  $method = 'getTypes';
  $params = array();
  return volacci_automatr_request($class, $method, $params);
}


function volacci_automatr_get_contact_activity_types_array() {
  try{
    $response = volacci_automatr_get_contact_activity_types();
  }catch (Exception $e) {
    watchdog('Automatr', t('Unable to fetch acitvity types'), array(), WATCHDOG_ERROR);
  }
  $types = get_value_from_results($response->result, 'text');
  return $types;
}


/*
 * Function to get the list of custom contact field labels
 */
function volacci_extra_get_custom_contact_field_labels() {
  $response = volacci_extra_get_all_custom_contact_fields();
  $field_labels = array();
  foreach ($response as $result) {
    $field_labels[$result] = $result;
  }
  return $field_labels;
}

/*
 * Function to get the list of custom contact field array
 */
function volacci_extra_get_custom_contact_fields_array() {
  $response = volacci_extra_get_custom_contact_fields();
  $field_array = array();
  foreach ($response->result->results as $result) {
    $field_array[$result->custom_attribute_id] = $result->custom_attribute;
  }
  return $field_array;
}


/*
 * Function to get the list of segments available
 */

function volacci_extra_get_segments($offset = '0', $limit_value = LIMIT_VALUE, $order_by = 'contact_segment_name', $order_dir = 'DESC', $extra_params = array()) {
  $class = 'ContactSegment';
  $method = 'getMultiple';
  $params = array(
    'offset' => $offset,
    'limit' => $limit_value,
    'order_by' => $order_by,
    'order_dir' => $order_dir,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/*
 * Function to get all segments all values
 */

function volacci_extra_get_all_segments_values() {
  if ($cached = cache_get('volacci_extra_get_all_segments_values', 'cache'))  {
    $full_segment = $cached->data;
  }
  if (empty($full_segment)) {
    $full_segment = array();
    try {
      check_volacci_connection();
      $response = volacci_extra_get_segments();
      $total_records = $response->result->totalRecords;
      if ($total_records > 0) {      
        // Define items per call
        $num_per_page = DEFAULT_RESULTS_PER_PAGE;
        // Loop through all segments
        for ($i = 0; $i < ceil($total_records/$num_per_page); $i++) {
          $offset = ($i) * $num_per_page;
          $response = volacci_extra_get_segments($offset, $num_per_page);
          $full_segment = array_merge($full_segment, $response->result->results);
        }
      }
      else {
        drupal_set_message(t("List is empty ! Contact Administrator.."));
      }
    } catch (Exception $e) {
        drupal_set_message($e->getMessage(), 'error');
    }
  }
  cache_set('volacci_extra_get_all_segments_values', $full_segment, 'cache', CACHE_TEMPORARY);
  return $full_segment;
}

/*
 * Function to get all segments key value pairs for list
 */

function volacci_extra_get_all_segments() {
  $full_segment = volacci_extra_get_all_segments_values();
  foreach ($full_segment as $values) {
    $full_segment_key_values[$values->contact_segment_id] = $values->contact_segment_name;
  }
  return $full_segment_key_values;
}

/**
 *    Function to get default segment
 */

function volacci_extra_get_default_segment() {
  $full_segment = volacci_extra_get_all_segments_values();
  foreach ($full_segment as $values) {
    if ($values->contact_segment_default == 1) {
      return $values->contact_segment_id;
    }
  }
  return '';
}



/*
 * Function to get all lists
 */

function volacci_extra_get_all_lists() {
  if ($cached = cache_get('volacci_extra_get_all_lists', 'cache'))  {
    $full_list_key_values = $cached->data;
  }
  if (empty($full_list_key_values)) {
    $full_list = array();
    $full_list_key_values = array();
    try {
      check_volacci_connection();
      $response = volacci_extra_get_lists();
      $total_records = $response->result->totalRecords;
      if ($total_records > 0) {      
        // Define items per call
        $num_per_page = DEFAULT_RESULTS_PER_PAGE;
        // Loop through all lists
        for ($i = 0; $i < ceil($total_records/$num_per_page); $i++) {
          $offset = ($i) * $num_per_page;
          $response = volacci_extra_get_lists($offset, $num_per_page);
          $full_list = array_merge($full_list, $response->result->results);
        }
        foreach ($full_list as $values) {
          $full_list_key_values[$values->email_list_id] = $values->email_list_name;
        }
      }
      else {
        drupal_set_message(t("List is empty ! Contact Administrator.."));
      }
    } catch (Exception $e) {
        drupal_set_message($e->getMessage(), 'error');
    }
  }
  cache_set('volacci_extra_get_all_lists', $full_list_key_values, 'cache', CACHE_TEMPORARY);
  return $full_list_key_values;
}

/*
 * Function to get the list of Email lists available
 */

function volacci_extra_get_lists($offset = '0', $limit_value = LIMIT_VALUE, $order_by = 'email_list_name', $order_dir = 'ASC', $extra_params = array()) {
  $class = 'EmailList';
  $method = 'getMultiple';
  $params = array(
    'offset' => $offset,
    'limit' =>  $limit_value,
    'order_by' => $order_by,
    'order_dir' => $order_dir,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}


/*
 * Function to get the list of Visitors
 */

function volacci_extra_get_visitors($offset = '0', $limit_value = LIMIT_VALUE, $order_by = 'mx_last_access', $order_dir = 'ASC', $extra_params = array()) {
  $class = 'Visit';
  $method = 'getAllMultiple';
  $params = array(
    'offset' => $offset,
    'limit' => $limit_value,
    'order_by' => $order_by,
    'order_dir' => $order_dir,
    'contact_segment_id' => $extra_params['contact_segment_id'],
    'start_date' => $extra_params['start_date'],
    'stop_date' => $extra_params['stop_date']
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/*
 * Function to get key value pair from the results array
 */

function get_key_value_from_results($response, $key_attribute, $value_attribute) {
  $results_array = array();
  foreach ($response->result->results as $result) {
    $result = (array) $result;
    $results_array[$result[$key_attribute]] = $result[$value_attribute];
  }
  return $results_array;
}

/*
 * Function to get key value pair from the results array
 */

function get_value_from_results($array_of_objects, $value_attribute) {
  $results_array = array();
  foreach ($array_of_objects as $key => $result) {
    $result = (array) $result;
    $results_array[$key] = $result[$value_attribute];
  }
  return $results_array;
}

/**
 * Returns the folder list of volacci
 * @return type
 */
function get_folder_list() {
  $dash = '-';
  $class = 'FolderEmailList';
  $method = 'getFolderTree';
  $params = array();
  $folders = volacci_automatr_request($class, $method, $params);
  if (!empty($folders->result)) {
    $folder_list = get_branch_folders($folders->result, $dash);
  }
  return iterator_to_array(new RecursiveIteratorIterator(new RecursiveArrayIterator($folder_list)), TRUE);
}

/**
 * Recursive function to get the sub-folders
 * @param type $folders
 * @param string $dash
 * @return type
 */
function get_branch_folders($folders, $dash) {
  foreach ($folders as $folder) {
    if (!$folder->is_root) {
      $folder_name = $dash . $folder->folder_name;
    }
    else {
      $folder_name = $folder->folder_name;
    }
    $folder_list[$folder->folder_id] = $folder_name;
    if (isset($folder->branches)) {
      $dash .= '-';
      $folder_list[] = get_branch_folders($folder->branches, $dash);
    }
  }
  return $folder_list;
}

/*
 * Function to get lead overlay score
 */

function volacci_extra_get_lead_overlay_score($contact_id, $overlay_id) {
  $class = 'Contact';
  $method = 'getOneWithScore';
  $params = array(
    'contact_id' => $contact_id,
    'overlay_id' => $overlay_id,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}



/*
 * Function to get all Reports
 */

function volacci_extra_get_all_reports() {
  if ($cached = cache_get('volacci_extra_get_all_reports', 'cache'))  {
    $full_reports_key_values = $cached->data;
  }
  if (empty($full_reports_key_values)) {
    $full_reports = array();
    $full_reports_key_values = array();
    try {
      check_volacci_connection();
      $response = volacci_extra_get_reports_list();
      $total_records = $response->result->totalRecords;
      if ($total_records > 0) {      
        // Define items per call
        $num_per_page = DEFAULT_RESULTS_PER_PAGE;
        // Loop through all reports
        for ($i = 0; $i < ceil($total_records/$num_per_page); $i++) {
          $offset = ($i) * $num_per_page;
          $response = volacci_extra_get_reports_list($offset, $num_per_page);
          $full_reports = array_merge($full_reports, $response->result->results);
        }
        foreach ($full_reports as $values) {
          $full_reports_key_values[$values->report_id] = $values->report_name;
        }
      }
      else {
        drupal_set_message(t("List is empty ! Contact Administrator.."));
      }
    } catch (Exception $e) {
        drupal_set_message($e->getMessage(), 'error');
    }
  }
  cache_set('volacci_extra_get_all_reports', $full_reports_key_values, 'cache', CACHE_TEMPORARY);
  return $full_reports_key_values;
}


function volacci_extra_get_reports_list($offset = '0', $limit_value = LIMIT_VALUE, $order_by = 'report_name', $order_dir = 'ASC', $extra_params = array()) {
  $class = 'Report';
  $method = 'getMultiple';
  $params = array(
    'offset' => $offset,
    'limit' => $limit_value,
    'order_by' => $order_by,
    'order_dir' => $order_dir,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

function volacci_extra_get_custom_fields_for_contact($contct_id) {
  $class = 'CustomAttribute';
  $method = 'getByContact';
  $params = array(
    'contact_id' => $contct_id,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/**
 * Helper function to check wether the volacci is configured.
 * @return boolean
 * @throws Exception
 */
function check_volacci_connection() {
  $automatr_login = variable_get('automatr_login', array());
  if (empty($automatr_login)) {
    throw new Exception(t('Volacci details are not entered, please enter in the') . ' ' . l(t('Volacci Automatr configuration page.'), 'admin/config/marketing/automatr/settings'));
  }
  return TRUE;
}

//To check wether the entered credentials are correct or not
function check_credentails($username, $password) {
  $class = 'User';
  $method = 'getOneByEmail';
  $params = array(
    'email' => $username,
  );
  $ch = curl_init('https://apps.net-results.com/api/v2/rpc/server.php?Controller=' . $class);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
  curl_setopt($ch, CURLOPT_USERPWD, $username . ':' . $password);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(array(
        'id' => uniqid(),
        'method' => $method,
        'jsonrpc' => '2.0',
        'params' => $params,
          )
      )
  );
  curl_setopt($ch, CURLOPT_POST, TRUE);
  $response = curl_exec($ch);
  $response = json_decode($response);
  if (!isset($response->result)) {
    throw new Exception('Unable to access the server at this time');
  }
  return $response;
}

function get_session_id($username, $password) {
  $class = 'User';
  $method = 'getSessionId';
  $params = array(
    'username' => $username,
    'password' => $password
  );
  $ch = curl_init('https://apps.net-results.com/api/v2/rpc/server.php?Controller=' . $class);
  $automatr_login = variable_get('automatr_login', array());
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(array(
        'id' => uniqid(),
        'method' => $method,
        'jsonrpc' => '2.0',
        'params' => $params,
          )
      )
  );
  curl_setopt($ch, CURLOPT_POST, TRUE);
  $response = curl_exec($ch);
  $response = json_decode($response);
  if (isset($response->error)) {
    throw new Exception('Unable to access the server at this time');
  }
  return $response;
}

/**
 * Default fields for exporting users and syncing to volacci
 * @return string
 */
function volacci_default_fields() {
  $volacci_automatr_default_fields = array('no_mapping' => 'No Mapping', 'address_1' => 'Address1', 'address_2' => 'Address2',
    'company' => 'Company Name', 'first_name' => 'First Name', 'last_name' => 'Last Name',
    'title' => 'Title', 'city' => 'City', 'state' => 'State', 'contact_postalcode' => 'Zip', 'country' => 'Country', 'lead_status_id' => 'Lead Stage',
    'home_phone' => 'Home Phone', 'work_phone' => 'Work Phone', 'mobile_phone' => 'Mobile Phone',
    'fax' => 'Fax', 'ip_address' => 'IP Address', 'user_id' => 'Lead Owner');
  return $volacci_automatr_default_fields;
}

/*
 * Function to get user membership lists : TODO
 */


function volacci_extra_get_contact_membership_lists($contact_id) {
  try {
    check_volacci_connection();
    $response = volacci_extra_get_mailing_info_for_contact($contact_id);
  }catch (Exception $e) {
  }
  $lists = $response->result->email_lists; 
  if (!isset($lists)) {
    return array();
  }
  $lists_array = array();
  foreach ($lists as $key => $list) {
    $lists_array[$list->email_list_id] = $list->email_list_name;
  }
  return $lists_array;
}


/*
 * Function to get user contact segments :TODO
 */


function volacci_extra_get_contact_segments($contact_id) {
  $class = 'Contact';
  $method = 'getEmailListMembershipConfiguration';
  $params = array(
    'intContactId' => $contact_id,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/*
 * Function to get user lead scores
 */
function volacci_extra_get_user_lead_scores() {
  $class = 'LeadScoreOverlay';
  $method = 'getAll';
  $params = array();
  $response = volacci_automatr_request($class, $method, $params);
  $lead_scores = array();
  foreach ($response->result as $lead_score) {
    if ($lead_score->lead_score_overlay_default == 1) {
      $lead_scores[$lead_score->lead_score_overlay_id] = $lead_score->lead_score_overlay_name;
    }
  }
  return $lead_scores;
}

/*
 * Function to get Email Lists
 */
function volacci_extra_get_mailing_info_for_contact($contact_id) {
  $class = 'Contact';
  $method = 'getMailingInfo';
  $params = array(
    'contact_id' => $contact_id,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

/*
 * Function check segment membership
 */
function volacci_extra_is_contact_in_segment($contact_id, $segment_id) {
  $class = 'ContactSegment';
  $method = 'getContactParticipation';
  $params = array(
    'contact_id' => $contact_id,
    'contact_segment_id' => $segment_id, 
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response->result;
}
/*
 * Function to get contact id from Mauuid
 */
function volacci_extra_get_contactid_from_mauuid($mauuid = '') {
  if ($mauuid == '') {
    if (isset($_COOKIE['__mauuid'])) {
      $mauuid = $_COOKIE['__mauuid'];
    }
    else{
      $mauuid = '';
    }
  }
  $class = 'Contact';
  $method = 'getContactIdByMauuid';
  $params = array(
    'mauuid' => $mauuid,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}

function get_contact_id_for_current_user() {
  try {
    check_volacci_connection();
    $response = volacci_extra_get_contactid_from_mauuid();
    $contact_id = $response->result->contact_id;
    if ($contact_id == '') {
      global $user;
      if ($user->uid > 0) {
        $response = volacci_automatr_get_contact_by_email($user->mail);
        $contact_id = $response->result->contact_id;
      }
      else{
        throw new Exception('Unable to find the current user in Autaomtr');
      }
    }
    return $contact_id;
  }catch (Exception $e) {
    watchdog('Automatr', t('Unable to find the user on Automatr'), array(), WATCHDOG_ERROR);
  }
}

function volacci_get_all_fields() {
  try{
    check_volacci_connection();
    $volacci_automatr_default_fields = volacci_default_fields();
    $volacci_automatr_custom_fields = volacci_extra_get_custom_contact_fields_array(); 
    $volacci_automatr_fields = $volacci_automatr_default_fields + $volacci_automatr_custom_fields;
  }catch (Exception $e) {
    watchdog('Automatr', t('Unable to fetch user fields from  Automatr'), array(), WATCHDOG_ERROR);
  }
  return $volacci_automatr_fields;
}

function volacci_get_all_fields_only() {
  try{
    $fields = volacci_get_all_fields();
    unset($fields['no_mapping']);
  }catch (Exception $e) {
    watchdog('Automatr', t('Unable to fetch user fields from  Automatr'), array(), WATCHDOG_ERROR);
  }
  return $fields;
}


function volacci_extra_get_lead_statuses($offset = '0', $limit_value = LIMIT_VALUE, $order_by = '', $order_dir = '', $extra_params = array()) {
  $class = 'LeadStatus';
  $method = 'getMultiple';
  $params = array(
    'offset' => $offset,
    'limit' => $limit_value,
    'order_by' => $order_by,
    'order_dir' => $order_dir,
  );
  $response = volacci_automatr_request($class, $method, $params);
  return $response;
}
