<?php

/**
 * @file
 * Function calls related to Custom Fields in Volacci Automatr
 *
 */


module_load_include('inc', 'volacci_automatr_extra', 'helper');

/**
 * Implements hook_form;
 * Custom Attribute
 * @param type $form
 * @param type $form_state
 * @return type
 */
function volacci_extra_custom_fields_form($form, &$form_state) {
  $form = array();
  try {
    check_volacci_connection();
    drupal_set_title(t('Create Custom Field'));
    $form['custom_field_help'] = array(
      '#markup' => "<div class='top-header'>" . t('While many default, system-provided fields are available for storing details about your contacts, 
                    Custom Fields allow you to store additional information specific to your company and your needs. Details such as customer number, 
                    account number, their website, and even their comments can be stored in fields you create.') . '</div>'
    );
    $form['custom_field_help'] = array(
      '#type' => 'item',
      '#markup' => t('Automatr currently allows you to create up to 50 Custom Fields. Each field may store up to 1024 characters.')
    );
    $form['custom_field_name'] = array(
      '#title' => t('Enter Custom Field Name'),
      '#type' => 'textfield',
      '#prefix' => "<div class = 'single-line-field'>",
      '#suffix' => "</div>"
    );
    $form['submit'] = array(
      '#value' => t('Save'),
      '#type' => 'submit',
    );
    $form['created-custom-fields'] = array(
      '#type' => 'item',
      '#markup' => volacci_automatr_extra_customfields_list()
    );
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $form;
}

/**
 * Implements hook_form_validate;
 * @param type $form
 * @param type $form_state
 */
function volacci_extra_custom_fields_form_validate($form, &$form_state) {
  $pattern = '/^[a-zA-Z0-9_.]+$/u';
  $custom_field_name = check_plain($form_state['values']['custom_field_name']);
  if (!preg_match($pattern, $custom_field_name)) {
    form_set_error('custom_field_name', $custom_field_name . ' contains characters which are non alphabetic and no digits.');
  }
}

/**
 * Implements hook_form_submit;
 * @param type $form
 * @param type $form_state
 */
function volacci_extra_custom_fields_form_submit($form, &$form_state) {
  try {
    $class = 'CustomAttribute';
    $method = 'setOne';
    $values = $form_state['values'];
    $custom_attribute = array(
      'custom_attribute' => check_plain($values['custom_field_name']),
      'rbac_role_id' => NULL,
    );
    $params = array(
      'custom_attribute' => $custom_attribute,
    );
    $response = volacci_automatr_request($class, $method, $params);
    drupal_set_message(t('The Custom Field has been created successfully.'));
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
}

function volacci_automatr_extra_customfields_list() {
  $customfields_list = '<div class="help-text">' . t('Custom fields that you have created:') . '</div>';
  try {
    check_volacci_connection();
    drupal_set_title(t('Custom Fields List'));
    $response = volacci_extra_get_custom_contact_fields();
    $total_records = $response->result->totalRecords;
    $order_by = "custom_attribute";
    $sort = "ASC";
    if (isset($_GET['sort'])) {
      if ($_GET['sort'] == "desc") {
        $sort = "DESC";
      }
    }
    if ($total_records > 0) {
      // Define items per page for paging
      $num_per_page = 50;
      // Initialize pager and gets current page
      $page = pager_default_initialize($total_records, $num_per_page);
      // Gets first record and last record to show        
      $offset = ($page) * $num_per_page;
      $last = ($offset + $num_per_page < $total_records)? $offset + $num_per_page : $total_records;
      $header = array(
                       array('data' => t('Field Name'), 'field' => 'field_name'), 
                     );
      $fields_list_table['header'] = $header;
      $fields_list_table['attributes'] = array('class' => array('field-list', 'va-table'));
      $render_array = volacci_pager_page_result(array('function_name' => 'volacci_extra_get_custom_contact_fields', 'offset' => $offset, 'last' => $last, 'table_params' => $fields_list_table, 'order_by' => $order_by, 'sort' => $sort));
      // Calls Drupal standard pager theme and set 5 page links on pager
      $render_array .= theme('pager');
      $customfields_list .= $render_array;
    }
    else {
      $customfields_list .= t('No Fields.');
    }
  } catch (Exception $e) {
    drupal_set_message($e->getMessage(), 'error');
  }
  return $customfields_list;
}
